/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.implementation.AccountSasImplUtil;
import com.azure.storage.common.implementation.SasImplUtils;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.common.sas.AccountSasSignatureValues;
import com.azure.storage.queue.QueueAsyncClient;
import com.azure.storage.queue.QueueServiceVersion;
import com.azure.storage.queue.implementation.AzureQueueStorageImpl;
import com.azure.storage.queue.implementation.models.ListQueuesIncludeType;
import com.azure.storage.queue.implementation.models.ServiceListQueuesSegmentHeaders;
import com.azure.storage.queue.models.QueueItem;
import com.azure.storage.queue.models.QueueServiceProperties;
import com.azure.storage.queue.models.QueueServiceStatistics;
import com.azure.storage.queue.models.QueuesSegmentOptions;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import reactor.core.publisher.Mono;

public final class QueueServiceAsyncClient {
    private final ClientLogger logger = new ClientLogger(QueueServiceAsyncClient.class);
    private final AzureQueueStorageImpl client;
    private final String accountName;
    private final QueueServiceVersion serviceVersion;

    QueueServiceAsyncClient(AzureQueueStorageImpl azureQueueStorage, String accountName, QueueServiceVersion serviceVersion) {
        this.client = azureQueueStorage;
        this.accountName = accountName;
        this.serviceVersion = serviceVersion;
    }

    public String getQueueServiceUrl() {
        return this.client.getUrl();
    }

    public QueueServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public QueueAsyncClient getQueueAsyncClient(String queueName) {
        return new QueueAsyncClient(this.client, queueName, this.accountName, this.serviceVersion);
    }

    public Mono<QueueAsyncClient> createQueue(String queueName) {
        try {
            return this.createQueueWithResponse(queueName, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<QueueAsyncClient>> createQueueWithResponse(String queueName, Map<String, String> metadata) {
        try {
            Objects.requireNonNull(queueName, "'queueName' cannot be null.");
            return FluxUtil.withContext(context -> this.createQueueWithResponse(queueName, metadata, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<QueueAsyncClient>> createQueueWithResponse(String queueName, Map<String, String> metadata, Context context) {
        QueueAsyncClient queueAsyncClient = new QueueAsyncClient(this.client, queueName, this.accountName, this.serviceVersion);
        return queueAsyncClient.createWithResponse(metadata, context).map(response -> new SimpleResponse(response, (Object)queueAsyncClient));
    }

    public Mono<Void> deleteQueue(String queueName) {
        try {
            return this.deleteQueueWithResponse(queueName).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> deleteQueueWithResponse(String queueName) {
        try {
            return FluxUtil.withContext(context -> this.deleteQueueWithResponse(queueName, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> deleteQueueWithResponse(String queueName, Context context) {
        return new QueueAsyncClient(this.client, queueName, this.accountName, this.serviceVersion).deleteWithResponse(context);
    }

    public PagedFlux<QueueItem> listQueues() {
        try {
            return this.listQueuesWithOptionalTimeout(null, null, null, Context.NONE);
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public PagedFlux<QueueItem> listQueues(QueuesSegmentOptions options) {
        try {
            return this.listQueuesWithOptionalTimeout(null, options, null, Context.NONE);
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    PagedFlux<QueueItem> listQueuesWithOptionalTimeout(String marker, QueuesSegmentOptions options, Duration timeout, Context context) {
        String prefix = options != null ? options.getPrefix() : null;
        Integer maxResultsPerPage = options != null ? options.getMaxResultsPerPage() : null;
        ArrayList<ListQueuesIncludeType> include = new ArrayList<ListQueuesIncludeType>();
        if (options != null && options.isIncludeMetadata()) {
            include.add(ListQueuesIncludeType.fromString(ListQueuesIncludeType.METADATA.toString()));
        }
        Function<String, Mono> retriever = nextMarker -> StorageImplUtils.applyOptionalTimeout(this.client.services().listQueuesSegmentWithRestResponseAsync(prefix, (String)nextMarker, maxResultsPerPage, (List<ListQueuesIncludeType>)include, null, null, context), (Duration)timeout).map(response -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), response.getValue().getQueueItems(), response.getValue().getNextMarker(), (Object)((ServiceListQueuesSegmentHeaders)response.getDeserializedHeaders())));
        return new PagedFlux(() -> (Mono)retriever.apply(marker), retriever);
    }

    public Mono<QueueServiceProperties> getProperties() {
        try {
            return this.getPropertiesWithResponse().flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<QueueServiceProperties>> getPropertiesWithResponse() {
        try {
            return FluxUtil.withContext(this::getPropertiesWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<QueueServiceProperties>> getPropertiesWithResponse(Context context) {
        context = context == null ? Context.NONE : context;
        return this.client.services().getPropertiesWithRestResponseAsync(context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, (Object)response.getValue()));
    }

    public Mono<Void> setProperties(QueueServiceProperties properties) {
        try {
            return this.setPropertiesWithResponse(properties).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> setPropertiesWithResponse(QueueServiceProperties properties) {
        try {
            return FluxUtil.withContext(context -> this.setPropertiesWithResponse(properties, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> setPropertiesWithResponse(QueueServiceProperties properties, Context context) {
        context = context == null ? Context.NONE : context;
        return this.client.services().setPropertiesWithRestResponseAsync(properties, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, null));
    }

    public Mono<QueueServiceStatistics> getStatistics() {
        try {
            return this.getStatisticsWithResponse().flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<QueueServiceStatistics>> getStatisticsWithResponse() {
        try {
            return FluxUtil.withContext(this::getStatisticsWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<QueueServiceStatistics>> getStatisticsWithResponse(Context context) {
        context = context == null ? Context.NONE : context;
        return this.client.services().getStatisticsWithRestResponseAsync(context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, (Object)response.getValue()));
    }

    public String getAccountName() {
        return this.accountName;
    }

    public HttpPipeline getHttpPipeline() {
        return this.client.getHttpPipeline();
    }

    public String generateAccountSas(AccountSasSignatureValues accountSasSignatureValues) {
        return this.generateAccountSas(accountSasSignatureValues, Context.NONE);
    }

    public String generateAccountSas(AccountSasSignatureValues accountSasSignatureValues, Context context) {
        return new AccountSasImplUtil(accountSasSignatureValues).generateSas(SasImplUtils.extractSharedKeyCredential((HttpPipeline)this.getHttpPipeline()), context);
    }
}

