/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.storage.queue.implementation.MessageIdsImpl;
import com.azure.storage.queue.implementation.MessagesImpl;
import com.azure.storage.queue.implementation.QueuesImpl;
import com.azure.storage.queue.implementation.ServicesImpl;

public final class AzureQueueStorageImpl {
    private String url;
    private String version;
    private HttpPipeline httpPipeline;
    private ServicesImpl services;
    private QueuesImpl queues;
    private MessagesImpl messages;
    private MessageIdsImpl messageIds;

    public String getUrl() {
        return this.url;
    }

    AzureQueueStorageImpl setUrl(String url) {
        this.url = url;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    AzureQueueStorageImpl setVersion(String version) {
        this.version = version;
        return this;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public ServicesImpl services() {
        return this.services;
    }

    public QueuesImpl queues() {
        return this.queues;
    }

    public MessagesImpl messages() {
        return this.messages;
    }

    public MessageIdsImpl messageIds() {
        return this.messageIds;
    }

    public AzureQueueStorageImpl() {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build());
    }

    public AzureQueueStorageImpl(HttpPipeline httpPipeline) {
        this.httpPipeline = httpPipeline;
        this.services = new ServicesImpl(this);
        this.queues = new QueuesImpl(this);
        this.messages = new MessagesImpl(this);
        this.messageIds = new MessageIdsImpl(this);
    }
}

