/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.storage.queue.implementation.AzureQueueStorageImpl;
import com.azure.storage.queue.implementation.models.MessageIdsDeleteResponse;
import com.azure.storage.queue.implementation.models.MessageIdsUpdateResponse;
import com.azure.storage.queue.implementation.models.QueueMessage;
import com.azure.storage.queue.models.QueueStorageException;
import reactor.core.publisher.Mono;

public final class MessageIdsImpl {
    private MessageIdsService service;
    private AzureQueueStorageImpl client;

    public MessageIdsImpl(AzureQueueStorageImpl client) {
        this.service = (MessageIdsService)RestProxy.create(MessageIdsService.class, (HttpPipeline)client.getHttpPipeline());
        this.client = client;
    }

    public Mono<MessageIdsUpdateResponse> updateWithRestResponseAsync(String queueName, String messageid, String popReceipt, int visibilitytimeout, Context context) {
        QueueMessage queueMessage = null;
        Integer timeout = null;
        String requestId = null;
        return this.service.update(queueName, messageid, this.client.getUrl(), queueMessage, popReceipt, visibilitytimeout, timeout, this.client.getVersion(), requestId, context);
    }

    public Mono<MessageIdsUpdateResponse> updateWithRestResponseAsync(String queueName, String messageid, String popReceipt, int visibilitytimeout, QueueMessage queueMessage, Integer timeout, String requestId, Context context) {
        return this.service.update(queueName, messageid, this.client.getUrl(), queueMessage, popReceipt, visibilitytimeout, timeout, this.client.getVersion(), requestId, context);
    }

    public Mono<MessageIdsDeleteResponse> deleteWithRestResponseAsync(String queueName, String messageid, String popReceipt, Context context) {
        Integer timeout = null;
        String requestId = null;
        return this.service.delete(queueName, messageid, this.client.getUrl(), popReceipt, timeout, this.client.getVersion(), requestId, context);
    }

    public Mono<MessageIdsDeleteResponse> deleteWithRestResponseAsync(String queueName, String messageid, String popReceipt, Integer timeout, String requestId, Context context) {
        return this.service.delete(queueName, messageid, this.client.getUrl(), popReceipt, timeout, this.client.getVersion(), requestId, context);
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureQueueStorageMessageIds")
    private static interface MessageIdsService {
        @Put(value="{queueName}/messages/{messageid}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<MessageIdsUpdateResponse> update(@PathParam(value="queueName") String var1, @PathParam(value="messageid") String var2, @HostParam(value="url") String var3, @BodyParam(value="application/xml; charset=utf-8") QueueMessage var4, @QueryParam(value="popreceipt") String var5, @QueryParam(value="visibilitytimeout") int var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-client-request-id") String var9, Context var10);

        @Delete(value="{queueName}/messages/{messageid}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<MessageIdsDeleteResponse> delete(@PathParam(value="queueName") String var1, @PathParam(value="messageid") String var2, @HostParam(value="url") String var3, @QueryParam(value="popreceipt") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, Context var8);
    }
}

