/*
 * Decompiled with CFR 0.152.
 */
package com.azure.xml;

import com.azure.xml.XmlProvider;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlWriter;
import com.azure.xml.implementation.DefaultXmlReader;
import com.azure.xml.implementation.DefaultXmlWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.xml.stream.XMLStreamException;

public final class XmlProviders {
    private static final String CANNOT_FIND_XML = "A request was made to load an XmlReader and XmlWriter provider but one could not be found on the classpath. If you are using a dependency manager, consider including a dependency that supplies a provider for XmlProvider or indicate to the loader to fallback to the default implementation. Additionally, refer to https://aka.ms/azsdk/java/docs/custom-xml to learn about writing your own implementation.";
    private static XmlProvider defaultProvider;

    private XmlProviders() {
    }

    public static XmlReader createReader(byte[] xml) throws XMLStreamException {
        return XmlProviders.createReader(xml, true);
    }

    public static XmlReader createReader(byte[] xml, boolean useDefault) throws XMLStreamException {
        if (defaultProvider == null) {
            if (useDefault) {
                return DefaultXmlReader.fromBytes(xml);
            }
            throw new IllegalStateException(CANNOT_FIND_XML);
        }
        return defaultProvider.createReader(xml);
    }

    public static XmlReader createReader(String xml) throws XMLStreamException {
        return XmlProviders.createReader(xml, true);
    }

    public static XmlReader createReader(String xml, boolean useDefault) throws XMLStreamException {
        if (defaultProvider == null) {
            if (useDefault) {
                return DefaultXmlReader.fromString(xml);
            }
            throw new IllegalStateException(CANNOT_FIND_XML);
        }
        return defaultProvider.createReader(xml);
    }

    public static XmlReader createReader(InputStream xml) throws XMLStreamException {
        return XmlProviders.createReader(xml, true);
    }

    public static XmlReader createReader(InputStream xml, boolean useDefault) throws XMLStreamException {
        if (defaultProvider == null) {
            if (useDefault) {
                return DefaultXmlReader.fromStream(xml);
            }
            throw new IllegalStateException(CANNOT_FIND_XML);
        }
        return defaultProvider.createReader(xml);
    }

    public static XmlReader createReader(Reader xml) throws XMLStreamException {
        return XmlProviders.createReader(xml, true);
    }

    public static XmlReader createReader(Reader xml, boolean useDefault) throws XMLStreamException {
        if (defaultProvider == null) {
            if (useDefault) {
                return DefaultXmlReader.fromReader(xml);
            }
            throw new IllegalStateException(CANNOT_FIND_XML);
        }
        return defaultProvider.createReader(xml);
    }

    public static XmlWriter createWriter(OutputStream xml) throws XMLStreamException {
        return XmlProviders.createWriter(xml, true);
    }

    public static XmlWriter createWriter(OutputStream xml, boolean useDefault) throws XMLStreamException {
        if (defaultProvider == null) {
            if (useDefault) {
                return DefaultXmlWriter.toStream(xml);
            }
            throw new IllegalStateException(CANNOT_FIND_XML);
        }
        return defaultProvider.createWriter(xml);
    }

    public static XmlWriter createWriter(Writer xml) throws XMLStreamException {
        return XmlProviders.createWriter(xml, true);
    }

    public static XmlWriter createWriter(Writer xml, boolean useDefault) throws XMLStreamException {
        if (defaultProvider == null) {
            if (useDefault) {
                return DefaultXmlWriter.toWriter(xml);
            }
            throw new IllegalStateException(CANNOT_FIND_XML);
        }
        return defaultProvider.createWriter(xml);
    }

    static {
        ServiceLoader<XmlProvider> serviceLoader = ServiceLoader.load(XmlProvider.class, XmlProvider.class.getClassLoader());
        Iterator<XmlProvider> it = serviceLoader.iterator();
        if (it.hasNext()) {
            defaultProvider = it.next();
        }
        while (it.hasNext()) {
            it.next();
        }
    }
}

