/*
 * Decompiled with CFR 0.152.
 */
package com.azure.xml;

import com.azure.xml.XmlSerializable;
import java.util.Base64;
import javax.xml.stream.XMLStreamException;

public abstract class XmlWriter
implements AutoCloseable {
    public final XmlWriter writeStartDocument() throws XMLStreamException {
        return this.writeStartDocument("1.0", "UTF-8");
    }

    public abstract XmlWriter writeStartDocument(String var1, String var2) throws XMLStreamException;

    public final XmlWriter writeStartElement(String localName) throws XMLStreamException {
        return this.writeStartElement(null, localName);
    }

    public abstract XmlWriter writeStartElement(String var1, String var2) throws XMLStreamException;

    public final XmlWriter writeStartSelfClosingElement(String localName) throws XMLStreamException {
        return this.writeStartSelfClosingElement(null, localName);
    }

    public abstract XmlWriter writeStartSelfClosingElement(String var1, String var2) throws XMLStreamException;

    public abstract XmlWriter writeEndElement() throws XMLStreamException;

    public abstract XmlWriter writeNamespace(String var1) throws XMLStreamException;

    public abstract XmlWriter writeNamespace(String var1, String var2) throws XMLStreamException;

    public final XmlWriter writeStringAttribute(String localName, String value) throws XMLStreamException {
        return this.writeStringAttribute(null, localName, value);
    }

    public abstract XmlWriter writeStringAttribute(String var1, String var2, String var3) throws XMLStreamException;

    public final XmlWriter writeBinaryAttribute(String localName, byte[] value) throws XMLStreamException {
        return this.writeBinaryAttribute(null, localName, value);
    }

    public final XmlWriter writeBinaryAttribute(String namespaceUri, String localName, byte[] value) throws XMLStreamException {
        if (value == null) {
            return this;
        }
        return this.writeStringAttribute(namespaceUri, localName, XmlWriter.convertBytesToString(value));
    }

    public final XmlWriter writeBooleanAttribute(String localName, boolean value) throws XMLStreamException {
        return this.writeStringAttribute(localName, String.valueOf(value));
    }

    public final XmlWriter writeBooleanAttribute(String namespaceUri, String localName, boolean value) throws XMLStreamException {
        return this.writeStringAttribute(namespaceUri, localName, String.valueOf(value));
    }

    public final XmlWriter writeBooleanAttribute(String localName, Boolean value) throws XMLStreamException {
        return this.writeBooleanAttribute((String)null, localName, value);
    }

    public final XmlWriter writeBooleanAttribute(String namespaceUri, String localName, Boolean value) throws XMLStreamException {
        if (value == null) {
            return this;
        }
        return this.writeStringAttribute(namespaceUri, localName, String.valueOf(value));
    }

    public final XmlWriter writeDoubleAttribute(String localName, double value) throws XMLStreamException {
        return this.writeStringAttribute(localName, String.valueOf(value));
    }

    public final XmlWriter writeDoubleAttribute(String namespaceUri, String localName, double value) throws XMLStreamException {
        return this.writeStringAttribute(namespaceUri, localName, String.valueOf(value));
    }

    public final XmlWriter writeFloatAttribute(String localName, float value) throws XMLStreamException {
        return this.writeStringAttribute(localName, String.valueOf(value));
    }

    public final XmlWriter writeFloatAttribute(String namespaceUri, String localName, float value) throws XMLStreamException {
        return this.writeStringAttribute(namespaceUri, localName, String.valueOf(value));
    }

    public final XmlWriter writeIntAttribute(String localName, int value) throws XMLStreamException {
        return this.writeStringAttribute(localName, String.valueOf(value));
    }

    public final XmlWriter writeIntAttribute(String namespaceUri, String localName, int value) throws XMLStreamException {
        return this.writeStringAttribute(namespaceUri, localName, String.valueOf(value));
    }

    public final XmlWriter writeLongAttribute(String localName, long value) throws XMLStreamException {
        return this.writeStringAttribute(localName, String.valueOf(value));
    }

    public final XmlWriter writeLongAttribute(String namespaceUri, String localName, long value) throws XMLStreamException {
        return this.writeStringAttribute(namespaceUri, localName, String.valueOf(value));
    }

    public final XmlWriter writeNumberAttribute(String localName, Number value) throws XMLStreamException {
        return this.writeNumberAttribute(null, localName, value);
    }

    public final XmlWriter writeNumberAttribute(String namespaceUri, String localName, Number value) throws XMLStreamException {
        if (value == null) {
            return this;
        }
        return this.writeStringAttribute(namespaceUri, localName, String.valueOf(value));
    }

    public final XmlWriter writeBinaryElement(String localName, byte[] value) throws XMLStreamException {
        return this.writeBinaryElement(null, localName, value);
    }

    public final XmlWriter writeBinaryElement(String namespaceUri, String localName, byte[] value) throws XMLStreamException {
        if (value == null) {
            return this;
        }
        return this.writeStartElement(namespaceUri, localName).writeBinary(value).writeEndElement();
    }

    public final XmlWriter writeBooleanElement(String localName, boolean value) throws XMLStreamException {
        return this.writeBooleanElement((String)null, localName, value);
    }

    public final XmlWriter writeBooleanElement(String namespaceUri, String localName, boolean value) throws XMLStreamException {
        return this.writeStartElement(namespaceUri, localName).writeBoolean(value).writeEndElement();
    }

    public final XmlWriter writeBooleanElement(String localName, Boolean value) throws XMLStreamException {
        return this.writeBooleanElement((String)null, localName, value);
    }

    public final XmlWriter writeBooleanElement(String namespaceUri, String localName, Boolean value) throws XMLStreamException {
        if (value == null) {
            return this;
        }
        return this.writeStartElement(namespaceUri, localName).writeBoolean((boolean)value).writeEndElement();
    }

    public final XmlWriter writeDoubleElement(String localName, double value) throws XMLStreamException {
        return this.writeDoubleElement(null, localName, value);
    }

    public final XmlWriter writeDoubleElement(String namespaceUri, String localName, double value) throws XMLStreamException {
        return this.writeStartElement(namespaceUri, localName).writeDouble(value).writeEndElement();
    }

    public final XmlWriter writeFloatElement(String localName, float value) throws XMLStreamException {
        return this.writeFloatElement(null, localName, value);
    }

    public final XmlWriter writeFloatElement(String namespaceUri, String localName, float value) throws XMLStreamException {
        return this.writeStartElement(namespaceUri, localName).writeFloat(value).writeEndElement();
    }

    public final XmlWriter writeIntElement(String localName, int value) throws XMLStreamException {
        return this.writeIntElement(null, localName, value);
    }

    public final XmlWriter writeIntElement(String namespaceUri, String localName, int value) throws XMLStreamException {
        return this.writeStartElement(namespaceUri, localName).writeInt(value).writeEndElement();
    }

    public final XmlWriter writeLongElement(String localName, long value) throws XMLStreamException {
        return this.writeLongElement(null, localName, value);
    }

    public final XmlWriter writeLongElement(String namespaceUri, String localName, long value) throws XMLStreamException {
        return this.writeStartElement(namespaceUri, localName).writeLong(value).writeEndElement();
    }

    public final XmlWriter writeNumberElement(String localName, Number value) throws XMLStreamException {
        return this.writeNumberElement(null, localName, value);
    }

    public final XmlWriter writeNumberElement(String namespaceUri, String localName, Number value) throws XMLStreamException {
        if (value == null) {
            return this;
        }
        return this.writeStartElement(namespaceUri, localName).writeNumber(value).writeEndElement();
    }

    public final XmlWriter writeStringElement(String localName, String value) throws XMLStreamException {
        return this.writeStringElement(null, localName, value);
    }

    public final XmlWriter writeStringElement(String namespaceUri, String localName, String value) throws XMLStreamException {
        if (value == null) {
            return this;
        }
        return this.writeStartElement(namespaceUri, localName).writeString(value).writeEndElement();
    }

    public final XmlWriter writeXml(XmlSerializable<?> value) throws XMLStreamException {
        return this.writeXml(value, null);
    }

    public final XmlWriter writeXml(XmlSerializable<?> value, String rootElementName) throws XMLStreamException {
        return value == null ? this : value.toXml(this, rootElementName);
    }

    public final XmlWriter writeBinary(byte[] value) throws XMLStreamException {
        return value == null ? this : this.writeString(XmlWriter.convertBytesToString(value));
    }

    public final XmlWriter writeBoolean(boolean value) throws XMLStreamException {
        return this.writeString(String.valueOf(value));
    }

    public final XmlWriter writeBoolean(Boolean value) throws XMLStreamException {
        return value == null ? this : this.writeString(String.valueOf(value));
    }

    public final XmlWriter writeDouble(double value) throws XMLStreamException {
        return this.writeString(String.valueOf(value));
    }

    public final XmlWriter writeFloat(float value) throws XMLStreamException {
        return this.writeString(String.valueOf(value));
    }

    public final XmlWriter writeInt(int value) throws XMLStreamException {
        return this.writeString(String.valueOf(value));
    }

    public final XmlWriter writeLong(long value) throws XMLStreamException {
        return this.writeString(String.valueOf(value));
    }

    public final XmlWriter writeNumber(Number value) throws XMLStreamException {
        return value == null ? this : this.writeString(String.valueOf(value));
    }

    public abstract XmlWriter writeString(String var1) throws XMLStreamException;

    public abstract XmlWriter writeCDataString(String var1) throws XMLStreamException;

    public abstract XmlWriter flush() throws XMLStreamException;

    @Override
    public abstract void close() throws XMLStreamException;

    private static String convertBytesToString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return Base64.getEncoder().encodeToString(bytes);
    }
}

