/*
 * Decompiled with CFR 0.152.
 */
package com.azure.xml.implementation;

import com.azure.xml.XmlWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public final class DefaultXmlWriter
extends XmlWriter {
    private static final XMLOutputFactory XML_OUTPUT_FACTORY = XMLOutputFactory.newInstance();
    private final XMLStreamWriter writer;

    public static XmlWriter toStream(OutputStream xml) throws XMLStreamException {
        Objects.requireNonNull(xml, "'xml' cannot be null.");
        return new DefaultXmlWriter(XML_OUTPUT_FACTORY.createXMLStreamWriter(new OutputStreamWriter(xml, StandardCharsets.UTF_8)));
    }

    public static XmlWriter toWriter(Writer xml) throws XMLStreamException {
        Objects.requireNonNull(xml, "'xml' cannot be null.");
        return new DefaultXmlWriter(XML_OUTPUT_FACTORY.createXMLStreamWriter(xml));
    }

    private DefaultXmlWriter(XMLStreamWriter writer) {
        this.writer = writer;
    }

    @Override
    public XmlWriter writeStartDocument(String version, String encoding) throws XMLStreamException {
        this.writer.writeStartDocument(encoding, version);
        return this;
    }

    @Override
    public XmlWriter writeStartElement(String namespaceUri, String localName) throws XMLStreamException {
        if (namespaceUri == null) {
            this.writer.writeStartElement(localName);
        } else {
            this.writer.writeStartElement(namespaceUri, localName);
        }
        return this;
    }

    @Override
    public XmlWriter writeStartSelfClosingElement(String namespaceUri, String localName) throws XMLStreamException {
        if (namespaceUri == null) {
            this.writer.writeEmptyElement(localName);
        } else {
            this.writer.writeEmptyElement(namespaceUri, localName);
        }
        return this;
    }

    @Override
    public XmlWriter writeNamespace(String namespaceUri) throws XMLStreamException {
        if (Objects.equals(this.writer.getNamespaceContext().getNamespaceURI(""), namespaceUri)) {
            return this;
        }
        this.writer.setDefaultNamespace(namespaceUri);
        this.writer.writeDefaultNamespace(namespaceUri);
        return this;
    }

    @Override
    public XmlWriter writeNamespace(String namespacePrefix, String namespaceUri) throws XMLStreamException {
        if (namespacePrefix == null || "xmlns".equals(namespacePrefix)) {
            return this.writeNamespace(namespacePrefix);
        }
        if (Objects.equals(this.writer.getNamespaceContext().getNamespaceURI(namespacePrefix), namespaceUri)) {
            return this;
        }
        this.writer.writeNamespace(namespacePrefix, namespaceUri);
        return this;
    }

    @Override
    public XmlWriter writeEndElement() throws XMLStreamException {
        this.writer.writeEndElement();
        return this;
    }

    @Override
    public XmlWriter writeStringAttribute(String namespaceUri, String localName, String value) throws XMLStreamException {
        if (value == null) {
            return this;
        }
        if (namespaceUri == null) {
            this.writer.writeAttribute(localName, value);
        } else {
            this.writer.writeAttribute(namespaceUri, localName, value);
        }
        return this;
    }

    @Override
    public XmlWriter writeString(String value) throws XMLStreamException {
        if (value == null) {
            return this;
        }
        this.writer.writeCharacters(value);
        return this;
    }

    @Override
    public XmlWriter writeCDataString(String value) throws XMLStreamException {
        if (value == null) {
            return this;
        }
        this.writer.writeCData(value);
        return this;
    }

    @Override
    public XmlWriter flush() throws XMLStreamException {
        this.writer.flush();
        return this;
    }

    @Override
    public void close() throws XMLStreamException {
        this.writer.flush();
        this.writer.close();
    }
}

