/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.advisor.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.advisor.fluent.models.ConfigDataProperties;
import com.azure.resourcemanager.advisor.models.CpuThreshold;
import com.azure.resourcemanager.advisor.models.DigestConfig;
import java.io.IOException;
import java.util.List;

public final class ConfigDataInner
extends ProxyResource {
    private ConfigDataProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private ConfigDataProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public Boolean exclude() {
        return this.innerProperties() == null ? null : this.innerProperties().exclude();
    }

    public ConfigDataInner withExclude(Boolean exclude) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConfigDataProperties();
        }
        this.innerProperties().withExclude(exclude);
        return this;
    }

    public CpuThreshold lowCpuThreshold() {
        return this.innerProperties() == null ? null : this.innerProperties().lowCpuThreshold();
    }

    public ConfigDataInner withLowCpuThreshold(CpuThreshold lowCpuThreshold) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConfigDataProperties();
        }
        this.innerProperties().withLowCpuThreshold(lowCpuThreshold);
        return this;
    }

    public List<DigestConfig> digests() {
        return this.innerProperties() == null ? null : this.innerProperties().digests();
    }

    public ConfigDataInner withDigests(List<DigestConfig> digests) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConfigDataProperties();
        }
        this.innerProperties().withDigests(digests);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ConfigDataInner fromJson(JsonReader jsonReader) throws IOException {
        return (ConfigDataInner)((Object)jsonReader.readObject(reader -> {
            ConfigDataInner deserializedConfigDataInner = new ConfigDataInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedConfigDataInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedConfigDataInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedConfigDataInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedConfigDataInner.innerProperties = ConfigDataProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConfigDataInner;
        }));
    }
}

