/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.advisor.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.advisor.models.CpuThreshold;
import com.azure.resourcemanager.advisor.models.DigestConfig;
import java.io.IOException;
import java.util.List;

public final class ConfigDataProperties
implements JsonSerializable<ConfigDataProperties> {
    private Boolean exclude;
    private CpuThreshold lowCpuThreshold;
    private List<DigestConfig> digests;

    public Boolean exclude() {
        return this.exclude;
    }

    public ConfigDataProperties withExclude(Boolean exclude) {
        this.exclude = exclude;
        return this;
    }

    public CpuThreshold lowCpuThreshold() {
        return this.lowCpuThreshold;
    }

    public ConfigDataProperties withLowCpuThreshold(CpuThreshold lowCpuThreshold) {
        this.lowCpuThreshold = lowCpuThreshold;
        return this;
    }

    public List<DigestConfig> digests() {
        return this.digests;
    }

    public ConfigDataProperties withDigests(List<DigestConfig> digests) {
        this.digests = digests;
        return this;
    }

    public void validate() {
        if (this.digests() != null) {
            this.digests().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("exclude", this.exclude);
        jsonWriter.writeStringField("lowCpuThreshold", this.lowCpuThreshold == null ? null : this.lowCpuThreshold.toString());
        jsonWriter.writeArrayField("digests", this.digests, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ConfigDataProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ConfigDataProperties)jsonReader.readObject(reader -> {
            ConfigDataProperties deserializedConfigDataProperties = new ConfigDataProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("exclude".equals(fieldName)) {
                    deserializedConfigDataProperties.exclude = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("lowCpuThreshold".equals(fieldName)) {
                    deserializedConfigDataProperties.lowCpuThreshold = CpuThreshold.fromString(reader.getString());
                    continue;
                }
                if ("digests".equals(fieldName)) {
                    List digests;
                    deserializedConfigDataProperties.digests = digests = reader.readArray(reader1 -> DigestConfig.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConfigDataProperties;
        });
    }
}

