/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.advisor.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.advisor.fluent.models.MetadataEntityProperties;
import com.azure.resourcemanager.advisor.models.MetadataSupportedValueDetail;
import com.azure.resourcemanager.advisor.models.Scenario;
import java.io.IOException;
import java.util.List;

public final class MetadataEntityInner
implements JsonSerializable<MetadataEntityInner> {
    private String id;
    private String type;
    private String name;
    private MetadataEntityProperties innerProperties;

    public String id() {
        return this.id;
    }

    public MetadataEntityInner withId(String id) {
        this.id = id;
        return this;
    }

    public String type() {
        return this.type;
    }

    public MetadataEntityInner withType(String type) {
        this.type = type;
        return this;
    }

    public String name() {
        return this.name;
    }

    public MetadataEntityInner withName(String name) {
        this.name = name;
        return this;
    }

    private MetadataEntityProperties innerProperties() {
        return this.innerProperties;
    }

    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    public MetadataEntityInner withDisplayName(String displayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MetadataEntityProperties();
        }
        this.innerProperties().withDisplayName(displayName);
        return this;
    }

    public List<String> dependsOn() {
        return this.innerProperties() == null ? null : this.innerProperties().dependsOn();
    }

    public MetadataEntityInner withDependsOn(List<String> dependsOn) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MetadataEntityProperties();
        }
        this.innerProperties().withDependsOn(dependsOn);
        return this;
    }

    public List<Scenario> applicableScenarios() {
        return this.innerProperties() == null ? null : this.innerProperties().applicableScenarios();
    }

    public MetadataEntityInner withApplicableScenarios(List<Scenario> applicableScenarios) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MetadataEntityProperties();
        }
        this.innerProperties().withApplicableScenarios(applicableScenarios);
        return this;
    }

    public List<MetadataSupportedValueDetail> supportedValues() {
        return this.innerProperties() == null ? null : this.innerProperties().supportedValues();
    }

    public MetadataEntityInner withSupportedValues(List<MetadataSupportedValueDetail> supportedValues) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MetadataEntityProperties();
        }
        this.innerProperties().withSupportedValues(supportedValues);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static MetadataEntityInner fromJson(JsonReader jsonReader) throws IOException {
        return (MetadataEntityInner)jsonReader.readObject(reader -> {
            MetadataEntityInner deserializedMetadataEntityInner = new MetadataEntityInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMetadataEntityInner.id = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMetadataEntityInner.type = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedMetadataEntityInner.name = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedMetadataEntityInner.innerProperties = MetadataEntityProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMetadataEntityInner;
        });
    }
}

