/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.advisor.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.advisor.models.MetadataSupportedValueDetail;
import com.azure.resourcemanager.advisor.models.Scenario;
import java.io.IOException;
import java.util.List;

public final class MetadataEntityProperties
implements JsonSerializable<MetadataEntityProperties> {
    private String displayName;
    private List<String> dependsOn;
    private List<Scenario> applicableScenarios;
    private List<MetadataSupportedValueDetail> supportedValues;

    public String displayName() {
        return this.displayName;
    }

    public MetadataEntityProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public List<String> dependsOn() {
        return this.dependsOn;
    }

    public MetadataEntityProperties withDependsOn(List<String> dependsOn) {
        this.dependsOn = dependsOn;
        return this;
    }

    public List<Scenario> applicableScenarios() {
        return this.applicableScenarios;
    }

    public MetadataEntityProperties withApplicableScenarios(List<Scenario> applicableScenarios) {
        this.applicableScenarios = applicableScenarios;
        return this;
    }

    public List<MetadataSupportedValueDetail> supportedValues() {
        return this.supportedValues;
    }

    public MetadataEntityProperties withSupportedValues(List<MetadataSupportedValueDetail> supportedValues) {
        this.supportedValues = supportedValues;
        return this;
    }

    public void validate() {
        if (this.supportedValues() != null) {
            this.supportedValues().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeArrayField("dependsOn", this.dependsOn, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("applicableScenarios", this.applicableScenarios, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("supportedValues", this.supportedValues, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static MetadataEntityProperties fromJson(JsonReader jsonReader) throws IOException {
        return (MetadataEntityProperties)jsonReader.readObject(reader -> {
            MetadataEntityProperties deserializedMetadataEntityProperties = new MetadataEntityProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("displayName".equals(fieldName)) {
                    deserializedMetadataEntityProperties.displayName = reader.getString();
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn;
                    deserializedMetadataEntityProperties.dependsOn = dependsOn = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("applicableScenarios".equals(fieldName)) {
                    List applicableScenarios;
                    deserializedMetadataEntityProperties.applicableScenarios = applicableScenarios = reader.readArray(reader1 -> Scenario.fromString(reader1.getString()));
                    continue;
                }
                if ("supportedValues".equals(fieldName)) {
                    List supportedValues;
                    deserializedMetadataEntityProperties.supportedValues = supportedValues = reader.readArray(reader1 -> MetadataSupportedValueDetail.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMetadataEntityProperties;
        });
    }
}

