/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.advisor.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.advisor.models.OperationDisplayInfo;
import java.io.IOException;

public final class OperationEntityInner
implements JsonSerializable<OperationEntityInner> {
    private String name;
    private OperationDisplayInfo display;

    public String name() {
        return this.name;
    }

    public OperationEntityInner withName(String name) {
        this.name = name;
        return this;
    }

    public OperationDisplayInfo display() {
        return this.display;
    }

    public OperationEntityInner withDisplay(OperationDisplayInfo display) {
        this.display = display;
        return this;
    }

    public void validate() {
        if (this.display() != null) {
            this.display().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("display", (JsonSerializable)this.display);
        return jsonWriter.writeEndObject();
    }

    public static OperationEntityInner fromJson(JsonReader jsonReader) throws IOException {
        return (OperationEntityInner)jsonReader.readObject(reader -> {
            OperationEntityInner deserializedOperationEntityInner = new OperationEntityInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedOperationEntityInner.name = reader.getString();
                    continue;
                }
                if ("display".equals(fieldName)) {
                    deserializedOperationEntityInner.display = OperationDisplayInfo.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOperationEntityInner;
        });
    }
}

