/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.advisor.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.advisor.models.Category;
import com.azure.resourcemanager.advisor.models.Impact;
import com.azure.resourcemanager.advisor.models.ResourceMetadata;
import com.azure.resourcemanager.advisor.models.ShortDescription;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public final class RecommendationProperties
implements JsonSerializable<RecommendationProperties> {
    private Category category;
    private Impact impact;
    private String impactedField;
    private String impactedValue;
    private OffsetDateTime lastUpdated;
    private Map<String, Object> metadata;
    private String recommendationTypeId;
    private ShortDescription shortDescription;
    private List<UUID> suppressionIds;
    private Map<String, String> extendedProperties;
    private ResourceMetadata resourceMetadata;
    private String description;
    private String label;
    private String learnMoreLink;
    private String potentialBenefits;
    private List<Map<String, Object>> actions;
    private Map<String, Object> remediation;
    private Map<String, Object> exposedMetadataProperties;

    public Category category() {
        return this.category;
    }

    public RecommendationProperties withCategory(Category category) {
        this.category = category;
        return this;
    }

    public Impact impact() {
        return this.impact;
    }

    public RecommendationProperties withImpact(Impact impact) {
        this.impact = impact;
        return this;
    }

    public String impactedField() {
        return this.impactedField;
    }

    public RecommendationProperties withImpactedField(String impactedField) {
        this.impactedField = impactedField;
        return this;
    }

    public String impactedValue() {
        return this.impactedValue;
    }

    public RecommendationProperties withImpactedValue(String impactedValue) {
        this.impactedValue = impactedValue;
        return this;
    }

    public OffsetDateTime lastUpdated() {
        return this.lastUpdated;
    }

    public RecommendationProperties withLastUpdated(OffsetDateTime lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    public Map<String, Object> metadata() {
        return this.metadata;
    }

    public RecommendationProperties withMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
        return this;
    }

    public String recommendationTypeId() {
        return this.recommendationTypeId;
    }

    public RecommendationProperties withRecommendationTypeId(String recommendationTypeId) {
        this.recommendationTypeId = recommendationTypeId;
        return this;
    }

    public ShortDescription shortDescription() {
        return this.shortDescription;
    }

    public RecommendationProperties withShortDescription(ShortDescription shortDescription) {
        this.shortDescription = shortDescription;
        return this;
    }

    public List<UUID> suppressionIds() {
        return this.suppressionIds;
    }

    public RecommendationProperties withSuppressionIds(List<UUID> suppressionIds) {
        this.suppressionIds = suppressionIds;
        return this;
    }

    public Map<String, String> extendedProperties() {
        return this.extendedProperties;
    }

    public RecommendationProperties withExtendedProperties(Map<String, String> extendedProperties) {
        this.extendedProperties = extendedProperties;
        return this;
    }

    public ResourceMetadata resourceMetadata() {
        return this.resourceMetadata;
    }

    public RecommendationProperties withResourceMetadata(ResourceMetadata resourceMetadata) {
        this.resourceMetadata = resourceMetadata;
        return this;
    }

    public String description() {
        return this.description;
    }

    public RecommendationProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public String label() {
        return this.label;
    }

    public RecommendationProperties withLabel(String label) {
        this.label = label;
        return this;
    }

    public String learnMoreLink() {
        return this.learnMoreLink;
    }

    public RecommendationProperties withLearnMoreLink(String learnMoreLink) {
        this.learnMoreLink = learnMoreLink;
        return this;
    }

    public String potentialBenefits() {
        return this.potentialBenefits;
    }

    public RecommendationProperties withPotentialBenefits(String potentialBenefits) {
        this.potentialBenefits = potentialBenefits;
        return this;
    }

    public List<Map<String, Object>> actions() {
        return this.actions;
    }

    public RecommendationProperties withActions(List<Map<String, Object>> actions) {
        this.actions = actions;
        return this;
    }

    public Map<String, Object> remediation() {
        return this.remediation;
    }

    public RecommendationProperties withRemediation(Map<String, Object> remediation) {
        this.remediation = remediation;
        return this;
    }

    public Map<String, Object> exposedMetadataProperties() {
        return this.exposedMetadataProperties;
    }

    public RecommendationProperties withExposedMetadataProperties(Map<String, Object> exposedMetadataProperties) {
        this.exposedMetadataProperties = exposedMetadataProperties;
        return this;
    }

    public void validate() {
        if (this.shortDescription() != null) {
            this.shortDescription().validate();
        }
        if (this.resourceMetadata() != null) {
            this.resourceMetadata().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("category", this.category == null ? null : this.category.toString());
        jsonWriter.writeStringField("impact", this.impact == null ? null : this.impact.toString());
        jsonWriter.writeStringField("impactedField", this.impactedField);
        jsonWriter.writeStringField("impactedValue", this.impactedValue);
        jsonWriter.writeStringField("lastUpdated", this.lastUpdated == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastUpdated));
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("recommendationTypeId", this.recommendationTypeId);
        jsonWriter.writeJsonField("shortDescription", (JsonSerializable)this.shortDescription);
        jsonWriter.writeArrayField("suppressionIds", this.suppressionIds, (writer, element) -> writer.writeString(Objects.toString(element, null)));
        jsonWriter.writeMapField("extendedProperties", this.extendedProperties, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("resourceMetadata", (JsonSerializable)this.resourceMetadata);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("label", this.label);
        jsonWriter.writeStringField("learnMoreLink", this.learnMoreLink);
        jsonWriter.writeStringField("potentialBenefits", this.potentialBenefits);
        jsonWriter.writeArrayField("actions", this.actions, (writer, element) -> writer.writeMap(element, (writer1, element1) -> writer1.writeUntyped(element1)));
        jsonWriter.writeMapField("remediation", this.remediation, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeMapField("exposedMetadataProperties", this.exposedMetadataProperties, (writer, element) -> writer.writeUntyped(element));
        return jsonWriter.writeEndObject();
    }

    public static RecommendationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (RecommendationProperties)jsonReader.readObject(reader -> {
            RecommendationProperties deserializedRecommendationProperties = new RecommendationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("category".equals(fieldName)) {
                    deserializedRecommendationProperties.category = Category.fromString(reader.getString());
                    continue;
                }
                if ("impact".equals(fieldName)) {
                    deserializedRecommendationProperties.impact = Impact.fromString(reader.getString());
                    continue;
                }
                if ("impactedField".equals(fieldName)) {
                    deserializedRecommendationProperties.impactedField = reader.getString();
                    continue;
                }
                if ("impactedValue".equals(fieldName)) {
                    deserializedRecommendationProperties.impactedValue = reader.getString();
                    continue;
                }
                if ("lastUpdated".equals(fieldName)) {
                    deserializedRecommendationProperties.lastUpdated = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    Map metadata;
                    deserializedRecommendationProperties.metadata = metadata = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("recommendationTypeId".equals(fieldName)) {
                    deserializedRecommendationProperties.recommendationTypeId = reader.getString();
                    continue;
                }
                if ("shortDescription".equals(fieldName)) {
                    deserializedRecommendationProperties.shortDescription = ShortDescription.fromJson(reader);
                    continue;
                }
                if ("suppressionIds".equals(fieldName)) {
                    List suppressionIds;
                    deserializedRecommendationProperties.suppressionIds = suppressionIds = reader.readArray(reader1 -> (UUID)reader1.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString())));
                    continue;
                }
                if ("extendedProperties".equals(fieldName)) {
                    Map extendedProperties;
                    deserializedRecommendationProperties.extendedProperties = extendedProperties = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("resourceMetadata".equals(fieldName)) {
                    deserializedRecommendationProperties.resourceMetadata = ResourceMetadata.fromJson(reader);
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedRecommendationProperties.description = reader.getString();
                    continue;
                }
                if ("label".equals(fieldName)) {
                    deserializedRecommendationProperties.label = reader.getString();
                    continue;
                }
                if ("learnMoreLink".equals(fieldName)) {
                    deserializedRecommendationProperties.learnMoreLink = reader.getString();
                    continue;
                }
                if ("potentialBenefits".equals(fieldName)) {
                    deserializedRecommendationProperties.potentialBenefits = reader.getString();
                    continue;
                }
                if ("actions".equals(fieldName)) {
                    List actions;
                    deserializedRecommendationProperties.actions = actions = reader.readArray(reader1 -> reader1.readMap(reader2 -> reader2.readUntyped()));
                    continue;
                }
                if ("remediation".equals(fieldName)) {
                    Map remediation;
                    deserializedRecommendationProperties.remediation = remediation = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("exposedMetadataProperties".equals(fieldName)) {
                    Map exposedMetadataProperties;
                    deserializedRecommendationProperties.exposedMetadataProperties = exposedMetadataProperties = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRecommendationProperties;
        });
    }
}

