/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.advisor.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.advisor.fluent.models.RecommendationProperties;
import com.azure.resourcemanager.advisor.models.Category;
import com.azure.resourcemanager.advisor.models.Impact;
import com.azure.resourcemanager.advisor.models.ResourceMetadata;
import com.azure.resourcemanager.advisor.models.ShortDescription;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class ResourceRecommendationBaseInner
extends ProxyResource {
    private RecommendationProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private RecommendationProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public Category category() {
        return this.innerProperties() == null ? null : this.innerProperties().category();
    }

    public ResourceRecommendationBaseInner withCategory(Category category) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationProperties();
        }
        this.innerProperties().withCategory(category);
        return this;
    }

    public Impact impact() {
        return this.innerProperties() == null ? null : this.innerProperties().impact();
    }

    public ResourceRecommendationBaseInner withImpact(Impact impact) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationProperties();
        }
        this.innerProperties().withImpact(impact);
        return this;
    }

    public String impactedField() {
        return this.innerProperties() == null ? null : this.innerProperties().impactedField();
    }

    public ResourceRecommendationBaseInner withImpactedField(String impactedField) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationProperties();
        }
        this.innerProperties().withImpactedField(impactedField);
        return this;
    }

    public String impactedValue() {
        return this.innerProperties() == null ? null : this.innerProperties().impactedValue();
    }

    public ResourceRecommendationBaseInner withImpactedValue(String impactedValue) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationProperties();
        }
        this.innerProperties().withImpactedValue(impactedValue);
        return this;
    }

    public OffsetDateTime lastUpdated() {
        return this.innerProperties() == null ? null : this.innerProperties().lastUpdated();
    }

    public ResourceRecommendationBaseInner withLastUpdated(OffsetDateTime lastUpdated) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationProperties();
        }
        this.innerProperties().withLastUpdated(lastUpdated);
        return this;
    }

    public Map<String, Object> metadata() {
        return this.innerProperties() == null ? null : this.innerProperties().metadata();
    }

    public ResourceRecommendationBaseInner withMetadata(Map<String, Object> metadata) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationProperties();
        }
        this.innerProperties().withMetadata(metadata);
        return this;
    }

    public String recommendationTypeId() {
        return this.innerProperties() == null ? null : this.innerProperties().recommendationTypeId();
    }

    public ResourceRecommendationBaseInner withRecommendationTypeId(String recommendationTypeId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationProperties();
        }
        this.innerProperties().withRecommendationTypeId(recommendationTypeId);
        return this;
    }

    public ShortDescription shortDescription() {
        return this.innerProperties() == null ? null : this.innerProperties().shortDescription();
    }

    public ResourceRecommendationBaseInner withShortDescription(ShortDescription shortDescription) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationProperties();
        }
        this.innerProperties().withShortDescription(shortDescription);
        return this;
    }

    public List<UUID> suppressionIds() {
        return this.innerProperties() == null ? null : this.innerProperties().suppressionIds();
    }

    public ResourceRecommendationBaseInner withSuppressionIds(List<UUID> suppressionIds) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationProperties();
        }
        this.innerProperties().withSuppressionIds(suppressionIds);
        return this;
    }

    public Map<String, String> extendedProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().extendedProperties();
    }

    public ResourceRecommendationBaseInner withExtendedProperties(Map<String, String> extendedProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationProperties();
        }
        this.innerProperties().withExtendedProperties(extendedProperties);
        return this;
    }

    public ResourceMetadata resourceMetadata() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceMetadata();
    }

    public ResourceRecommendationBaseInner withResourceMetadata(ResourceMetadata resourceMetadata) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationProperties();
        }
        this.innerProperties().withResourceMetadata(resourceMetadata);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public ResourceRecommendationBaseInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public String label() {
        return this.innerProperties() == null ? null : this.innerProperties().label();
    }

    public ResourceRecommendationBaseInner withLabel(String label) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationProperties();
        }
        this.innerProperties().withLabel(label);
        return this;
    }

    public String learnMoreLink() {
        return this.innerProperties() == null ? null : this.innerProperties().learnMoreLink();
    }

    public ResourceRecommendationBaseInner withLearnMoreLink(String learnMoreLink) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationProperties();
        }
        this.innerProperties().withLearnMoreLink(learnMoreLink);
        return this;
    }

    public String potentialBenefits() {
        return this.innerProperties() == null ? null : this.innerProperties().potentialBenefits();
    }

    public ResourceRecommendationBaseInner withPotentialBenefits(String potentialBenefits) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationProperties();
        }
        this.innerProperties().withPotentialBenefits(potentialBenefits);
        return this;
    }

    public List<Map<String, Object>> actions() {
        return this.innerProperties() == null ? null : this.innerProperties().actions();
    }

    public ResourceRecommendationBaseInner withActions(List<Map<String, Object>> actions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationProperties();
        }
        this.innerProperties().withActions(actions);
        return this;
    }

    public Map<String, Object> remediation() {
        return this.innerProperties() == null ? null : this.innerProperties().remediation();
    }

    public ResourceRecommendationBaseInner withRemediation(Map<String, Object> remediation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationProperties();
        }
        this.innerProperties().withRemediation(remediation);
        return this;
    }

    public Map<String, Object> exposedMetadataProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().exposedMetadataProperties();
    }

    public ResourceRecommendationBaseInner withExposedMetadataProperties(Map<String, Object> exposedMetadataProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendationProperties();
        }
        this.innerProperties().withExposedMetadataProperties(exposedMetadataProperties);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ResourceRecommendationBaseInner fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceRecommendationBaseInner)((Object)jsonReader.readObject(reader -> {
            ResourceRecommendationBaseInner deserializedResourceRecommendationBaseInner = new ResourceRecommendationBaseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedResourceRecommendationBaseInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedResourceRecommendationBaseInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedResourceRecommendationBaseInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedResourceRecommendationBaseInner.innerProperties = RecommendationProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceRecommendationBaseInner;
        }));
    }
}

