/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.advisor.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.advisor.fluent.models.SuppressionProperties;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class SuppressionContractInner
extends ProxyResource {
    private SuppressionProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private SuppressionProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String suppressionId() {
        return this.innerProperties() == null ? null : this.innerProperties().suppressionId();
    }

    public SuppressionContractInner withSuppressionId(String suppressionId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SuppressionProperties();
        }
        this.innerProperties().withSuppressionId(suppressionId);
        return this;
    }

    public String ttl() {
        return this.innerProperties() == null ? null : this.innerProperties().ttl();
    }

    public SuppressionContractInner withTtl(String ttl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SuppressionProperties();
        }
        this.innerProperties().withTtl(ttl);
        return this;
    }

    public OffsetDateTime expirationTimestamp() {
        return this.innerProperties() == null ? null : this.innerProperties().expirationTimestamp();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static SuppressionContractInner fromJson(JsonReader jsonReader) throws IOException {
        return (SuppressionContractInner)((Object)jsonReader.readObject(reader -> {
            SuppressionContractInner deserializedSuppressionContractInner = new SuppressionContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSuppressionContractInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSuppressionContractInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSuppressionContractInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSuppressionContractInner.innerProperties = SuppressionProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSuppressionContractInner;
        }));
    }
}

