/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.advisor.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class SuppressionProperties
implements JsonSerializable<SuppressionProperties> {
    private String suppressionId;
    private String ttl;
    private OffsetDateTime expirationTimestamp;

    public String suppressionId() {
        return this.suppressionId;
    }

    public SuppressionProperties withSuppressionId(String suppressionId) {
        this.suppressionId = suppressionId;
        return this;
    }

    public String ttl() {
        return this.ttl;
    }

    public SuppressionProperties withTtl(String ttl) {
        this.ttl = ttl;
        return this;
    }

    public OffsetDateTime expirationTimestamp() {
        return this.expirationTimestamp;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("suppressionId", this.suppressionId);
        jsonWriter.writeStringField("ttl", this.ttl);
        return jsonWriter.writeEndObject();
    }

    public static SuppressionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SuppressionProperties)jsonReader.readObject(reader -> {
            SuppressionProperties deserializedSuppressionProperties = new SuppressionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("suppressionId".equals(fieldName)) {
                    deserializedSuppressionProperties.suppressionId = reader.getString();
                    continue;
                }
                if ("ttl".equals(fieldName)) {
                    deserializedSuppressionProperties.ttl = reader.getString();
                    continue;
                }
                if ("expirationTimeStamp".equals(fieldName)) {
                    deserializedSuppressionProperties.expirationTimestamp = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSuppressionProperties;
        });
    }
}

