/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.advisor.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.advisor.AdvisorManager;
import com.azure.resourcemanager.advisor.fluent.models.ConfigDataInner;
import com.azure.resourcemanager.advisor.models.ConfigData;
import com.azure.resourcemanager.advisor.models.ConfigurationName;
import com.azure.resourcemanager.advisor.models.CpuThreshold;
import com.azure.resourcemanager.advisor.models.DigestConfig;
import java.util.Collections;
import java.util.List;

public final class ConfigDataImpl
implements ConfigData,
ConfigData.Definition {
    private ConfigDataInner innerObject;
    private final AdvisorManager serviceManager;
    private ConfigurationName configurationName;
    private String resourceGroup;

    ConfigDataImpl(ConfigDataInner innerObject, AdvisorManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public Boolean exclude() {
        return this.innerModel().exclude();
    }

    @Override
    public CpuThreshold lowCpuThreshold() {
        return this.innerModel().lowCpuThreshold();
    }

    @Override
    public List<DigestConfig> digests() {
        List<DigestConfig> inner = this.innerModel().digests();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public ConfigDataInner innerModel() {
        return this.innerObject;
    }

    private AdvisorManager manager() {
        return this.serviceManager;
    }

    @Override
    public ConfigDataImpl withExistingResourceGroup(String resourceGroup) {
        this.resourceGroup = resourceGroup;
        return this;
    }

    @Override
    public ConfigData create() {
        this.innerObject = (ConfigDataInner)((Object)this.serviceManager.serviceClient().getConfigurations().createInResourceGroupWithResponse(this.configurationName, this.resourceGroup, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public ConfigData create(Context context) {
        this.innerObject = (ConfigDataInner)((Object)this.serviceManager.serviceClient().getConfigurations().createInResourceGroupWithResponse(this.configurationName, this.resourceGroup, this.innerModel(), context).getValue());
        return this;
    }

    ConfigDataImpl(ConfigurationName name, AdvisorManager serviceManager) {
        this.innerObject = new ConfigDataInner();
        this.serviceManager = serviceManager;
        this.configurationName = name;
    }

    @Override
    public ConfigDataImpl withExclude(Boolean exclude) {
        this.innerModel().withExclude(exclude);
        return this;
    }

    @Override
    public ConfigDataImpl withLowCpuThreshold(CpuThreshold lowCpuThreshold) {
        this.innerModel().withLowCpuThreshold(lowCpuThreshold);
        return this;
    }

    @Override
    public ConfigDataImpl withDigests(List<DigestConfig> digests) {
        this.innerModel().withDigests(digests);
        return this;
    }
}

