/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.advisor.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.advisor.AdvisorManager;
import com.azure.resourcemanager.advisor.fluent.ConfigurationsClient;
import com.azure.resourcemanager.advisor.fluent.models.ConfigDataInner;
import com.azure.resourcemanager.advisor.implementation.ConfigDataImpl;
import com.azure.resourcemanager.advisor.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.advisor.models.ConfigData;
import com.azure.resourcemanager.advisor.models.ConfigurationName;
import com.azure.resourcemanager.advisor.models.Configurations;

public final class ConfigurationsImpl
implements Configurations {
    private static final ClientLogger LOGGER = new ClientLogger(ConfigurationsImpl.class);
    private final ConfigurationsClient innerClient;
    private final AdvisorManager serviceManager;

    public ConfigurationsImpl(ConfigurationsClient innerClient, AdvisorManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ConfigData> list() {
        PagedIterable<ConfigDataInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ConfigDataImpl((ConfigDataInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ConfigData> list(Context context) {
        PagedIterable<ConfigDataInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ConfigDataImpl((ConfigDataInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<ConfigData> createInSubscriptionWithResponse(ConfigurationName configurationName, ConfigDataInner configContract, Context context) {
        Response<ConfigDataInner> inner = this.serviceClient().createInSubscriptionWithResponse(configurationName, configContract, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ConfigDataImpl((ConfigDataInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ConfigData createInSubscription(ConfigurationName configurationName, ConfigDataInner configContract) {
        ConfigDataInner inner = this.serviceClient().createInSubscription(configurationName, configContract);
        if (inner != null) {
            return new ConfigDataImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<ConfigData> listByResourceGroup(String resourceGroup) {
        PagedIterable<ConfigDataInner> inner = this.serviceClient().listByResourceGroup(resourceGroup);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ConfigDataImpl((ConfigDataInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ConfigData> listByResourceGroup(String resourceGroup, Context context) {
        PagedIterable<ConfigDataInner> inner = this.serviceClient().listByResourceGroup(resourceGroup, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ConfigDataImpl((ConfigDataInner)((Object)inner1), this.manager()));
    }

    private ConfigurationsClient serviceClient() {
        return this.innerClient;
    }

    private AdvisorManager manager() {
        return this.serviceManager;
    }

    @Override
    public ConfigDataImpl define(ConfigurationName name) {
        return new ConfigDataImpl(name, this.manager());
    }
}

