/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.advisor.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.advisor.AdvisorManager;
import com.azure.resourcemanager.advisor.fluent.OperationsClient;
import com.azure.resourcemanager.advisor.fluent.models.OperationEntityInner;
import com.azure.resourcemanager.advisor.implementation.OperationEntityImpl;
import com.azure.resourcemanager.advisor.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.advisor.models.OperationEntity;
import com.azure.resourcemanager.advisor.models.Operations;

public final class OperationsImpl
implements Operations {
    private static final ClientLogger LOGGER = new ClientLogger(OperationsImpl.class);
    private final OperationsClient innerClient;
    private final AdvisorManager serviceManager;

    public OperationsImpl(OperationsClient innerClient, AdvisorManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<OperationEntity> list() {
        PagedIterable<OperationEntityInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new OperationEntityImpl((OperationEntityInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<OperationEntity> list(Context context) {
        PagedIterable<OperationEntityInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new OperationEntityImpl((OperationEntityInner)inner1, this.manager()));
    }

    private OperationsClient serviceClient() {
        return this.innerClient;
    }

    private AdvisorManager manager() {
        return this.serviceManager;
    }
}

