/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.advisor.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.advisor.AdvisorManager;
import com.azure.resourcemanager.advisor.fluent.RecommendationMetadatasClient;
import com.azure.resourcemanager.advisor.fluent.models.MetadataEntityInner;
import com.azure.resourcemanager.advisor.implementation.MetadataEntityImpl;
import com.azure.resourcemanager.advisor.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.advisor.models.MetadataEntity;
import com.azure.resourcemanager.advisor.models.RecommendationMetadatas;

public final class RecommendationMetadatasImpl
implements RecommendationMetadatas {
    private static final ClientLogger LOGGER = new ClientLogger(RecommendationMetadatasImpl.class);
    private final RecommendationMetadatasClient innerClient;
    private final AdvisorManager serviceManager;

    public RecommendationMetadatasImpl(RecommendationMetadatasClient innerClient, AdvisorManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<MetadataEntity> getWithResponse(String name, Context context) {
        Response<MetadataEntityInner> inner = this.serviceClient().getWithResponse(name, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new MetadataEntityImpl((MetadataEntityInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public MetadataEntity get(String name) {
        MetadataEntityInner inner = this.serviceClient().get(name);
        if (inner != null) {
            return new MetadataEntityImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<MetadataEntity> list() {
        PagedIterable<MetadataEntityInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new MetadataEntityImpl((MetadataEntityInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<MetadataEntity> list(Context context) {
        PagedIterable<MetadataEntityInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new MetadataEntityImpl((MetadataEntityInner)inner1, this.manager()));
    }

    private RecommendationMetadatasClient serviceClient() {
        return this.innerClient;
    }

    private AdvisorManager manager() {
        return this.serviceManager;
    }
}

