/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.advisor.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.advisor.AdvisorManager;
import com.azure.resourcemanager.advisor.fluent.RecommendationsClient;
import com.azure.resourcemanager.advisor.fluent.models.ResourceRecommendationBaseInner;
import com.azure.resourcemanager.advisor.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.advisor.implementation.ResourceRecommendationBaseImpl;
import com.azure.resourcemanager.advisor.models.Recommendations;
import com.azure.resourcemanager.advisor.models.RecommendationsGenerateResponse;
import com.azure.resourcemanager.advisor.models.ResourceRecommendationBase;
import java.util.UUID;

public final class RecommendationsImpl
implements Recommendations {
    private static final ClientLogger LOGGER = new ClientLogger(RecommendationsImpl.class);
    private final RecommendationsClient innerClient;
    private final AdvisorManager serviceManager;

    public RecommendationsImpl(RecommendationsClient innerClient, AdvisorManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public RecommendationsGenerateResponse generateWithResponse(Context context) {
        return this.serviceClient().generateWithResponse(context);
    }

    @Override
    public void generate() {
        this.serviceClient().generate();
    }

    @Override
    public Response<Void> getGenerateStatusWithResponse(UUID operationId, Context context) {
        return this.serviceClient().getGenerateStatusWithResponse(operationId, context);
    }

    @Override
    public void getGenerateStatus(UUID operationId) {
        this.serviceClient().getGenerateStatus(operationId);
    }

    @Override
    public PagedIterable<ResourceRecommendationBase> list() {
        PagedIterable<ResourceRecommendationBaseInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ResourceRecommendationBaseImpl((ResourceRecommendationBaseInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ResourceRecommendationBase> list(String filter, Integer top, String skipToken, Context context) {
        PagedIterable<ResourceRecommendationBaseInner> inner = this.serviceClient().list(filter, top, skipToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ResourceRecommendationBaseImpl((ResourceRecommendationBaseInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<ResourceRecommendationBase> getWithResponse(String resourceUri, String recommendationId, Context context) {
        Response<ResourceRecommendationBaseInner> inner = this.serviceClient().getWithResponse(resourceUri, recommendationId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ResourceRecommendationBaseImpl((ResourceRecommendationBaseInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ResourceRecommendationBase get(String resourceUri, String recommendationId) {
        ResourceRecommendationBaseInner inner = this.serviceClient().get(resourceUri, recommendationId);
        if (inner != null) {
            return new ResourceRecommendationBaseImpl(inner, this.manager());
        }
        return null;
    }

    private RecommendationsClient serviceClient() {
        return this.innerClient;
    }

    private AdvisorManager manager() {
        return this.serviceManager;
    }
}

