/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.advisor.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.advisor.AdvisorManager;
import com.azure.resourcemanager.advisor.fluent.models.SuppressionContractInner;
import com.azure.resourcemanager.advisor.models.SuppressionContract;
import java.time.OffsetDateTime;

public final class SuppressionContractImpl
implements SuppressionContract,
SuppressionContract.Definition {
    private SuppressionContractInner innerObject;
    private final AdvisorManager serviceManager;
    private String resourceUri;
    private String recommendationId;
    private String name;

    SuppressionContractImpl(SuppressionContractInner innerObject, AdvisorManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String suppressionId() {
        return this.innerModel().suppressionId();
    }

    @Override
    public String ttl() {
        return this.innerModel().ttl();
    }

    @Override
    public OffsetDateTime expirationTimestamp() {
        return this.innerModel().expirationTimestamp();
    }

    @Override
    public SuppressionContractInner innerModel() {
        return this.innerObject;
    }

    private AdvisorManager manager() {
        return this.serviceManager;
    }

    @Override
    public SuppressionContractImpl withExistingRecommendation(String resourceUri, String recommendationId) {
        this.resourceUri = resourceUri;
        this.recommendationId = recommendationId;
        return this;
    }

    @Override
    public SuppressionContract create() {
        this.innerObject = (SuppressionContractInner)((Object)this.serviceManager.serviceClient().getSuppressions().createWithResponse(this.resourceUri, this.recommendationId, this.name, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public SuppressionContract create(Context context) {
        this.innerObject = (SuppressionContractInner)((Object)this.serviceManager.serviceClient().getSuppressions().createWithResponse(this.resourceUri, this.recommendationId, this.name, this.innerModel(), context).getValue());
        return this;
    }

    SuppressionContractImpl(String name, AdvisorManager serviceManager) {
        this.innerObject = new SuppressionContractInner();
        this.serviceManager = serviceManager;
        this.name = name;
    }

    @Override
    public SuppressionContract refresh() {
        this.innerObject = (SuppressionContractInner)((Object)this.serviceManager.serviceClient().getSuppressions().getWithResponse(this.resourceUri, this.recommendationId, this.name, Context.NONE).getValue());
        return this;
    }

    @Override
    public SuppressionContract refresh(Context context) {
        this.innerObject = (SuppressionContractInner)((Object)this.serviceManager.serviceClient().getSuppressions().getWithResponse(this.resourceUri, this.recommendationId, this.name, context).getValue());
        return this;
    }

    @Override
    public SuppressionContractImpl withSuppressionId(String suppressionId) {
        this.innerModel().withSuppressionId(suppressionId);
        return this;
    }

    @Override
    public SuppressionContractImpl withTtl(String ttl) {
        this.innerModel().withTtl(ttl);
        return this;
    }
}

