/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.advisor.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.advisor.AdvisorManager;
import com.azure.resourcemanager.advisor.fluent.SuppressionsClient;
import com.azure.resourcemanager.advisor.fluent.models.SuppressionContractInner;
import com.azure.resourcemanager.advisor.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.advisor.implementation.SuppressionContractImpl;
import com.azure.resourcemanager.advisor.models.SuppressionContract;
import com.azure.resourcemanager.advisor.models.Suppressions;

public final class SuppressionsImpl
implements Suppressions {
    private static final ClientLogger LOGGER = new ClientLogger(SuppressionsImpl.class);
    private final SuppressionsClient innerClient;
    private final AdvisorManager serviceManager;

    public SuppressionsImpl(SuppressionsClient innerClient, AdvisorManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<SuppressionContract> getWithResponse(String resourceUri, String recommendationId, String name, Context context) {
        Response<SuppressionContractInner> inner = this.serviceClient().getWithResponse(resourceUri, recommendationId, name, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SuppressionContractImpl((SuppressionContractInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public SuppressionContract get(String resourceUri, String recommendationId, String name) {
        SuppressionContractInner inner = this.serviceClient().get(resourceUri, recommendationId, name);
        if (inner != null) {
            return new SuppressionContractImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceUri, String recommendationId, String name, Context context) {
        return this.serviceClient().deleteWithResponse(resourceUri, recommendationId, name, context);
    }

    @Override
    public void delete(String resourceUri, String recommendationId, String name) {
        this.serviceClient().delete(resourceUri, recommendationId, name);
    }

    @Override
    public PagedIterable<SuppressionContract> list() {
        PagedIterable<SuppressionContractInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SuppressionContractImpl((SuppressionContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SuppressionContract> list(Integer top, String skipToken, Context context) {
        PagedIterable<SuppressionContractInner> inner = this.serviceClient().list(top, skipToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SuppressionContractImpl((SuppressionContractInner)((Object)inner1), this.manager()));
    }

    @Override
    public SuppressionContract getById(String id) {
        String resourceUri = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{resourceUri}/providers/Microsoft.Advisor/recommendations/{recommendationId}/suppressions/{name}", "resourceUri");
        if (resourceUri == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceUri'.", id)));
        }
        String recommendationId = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{resourceUri}/providers/Microsoft.Advisor/recommendations/{recommendationId}/suppressions/{name}", "recommendationId");
        if (recommendationId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'recommendations'.", id)));
        }
        String name = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{resourceUri}/providers/Microsoft.Advisor/recommendations/{recommendationId}/suppressions/{name}", "name");
        if (name == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'suppressions'.", id)));
        }
        return (SuppressionContract)this.getWithResponse(resourceUri, recommendationId, name, Context.NONE).getValue();
    }

    @Override
    public Response<SuppressionContract> getByIdWithResponse(String id, Context context) {
        String resourceUri = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{resourceUri}/providers/Microsoft.Advisor/recommendations/{recommendationId}/suppressions/{name}", "resourceUri");
        if (resourceUri == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceUri'.", id)));
        }
        String recommendationId = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{resourceUri}/providers/Microsoft.Advisor/recommendations/{recommendationId}/suppressions/{name}", "recommendationId");
        if (recommendationId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'recommendations'.", id)));
        }
        String name = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{resourceUri}/providers/Microsoft.Advisor/recommendations/{recommendationId}/suppressions/{name}", "name");
        if (name == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'suppressions'.", id)));
        }
        return this.getWithResponse(resourceUri, recommendationId, name, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceUri = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{resourceUri}/providers/Microsoft.Advisor/recommendations/{recommendationId}/suppressions/{name}", "resourceUri");
        if (resourceUri == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceUri'.", id)));
        }
        String recommendationId = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{resourceUri}/providers/Microsoft.Advisor/recommendations/{recommendationId}/suppressions/{name}", "recommendationId");
        if (recommendationId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'recommendations'.", id)));
        }
        String name = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{resourceUri}/providers/Microsoft.Advisor/recommendations/{recommendationId}/suppressions/{name}", "name");
        if (name == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'suppressions'.", id)));
        }
        this.deleteWithResponse(resourceUri, recommendationId, name, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceUri = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{resourceUri}/providers/Microsoft.Advisor/recommendations/{recommendationId}/suppressions/{name}", "resourceUri");
        if (resourceUri == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceUri'.", id)));
        }
        String recommendationId = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{resourceUri}/providers/Microsoft.Advisor/recommendations/{recommendationId}/suppressions/{name}", "recommendationId");
        if (recommendationId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'recommendations'.", id)));
        }
        String name = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{resourceUri}/providers/Microsoft.Advisor/recommendations/{recommendationId}/suppressions/{name}", "name");
        if (name == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'suppressions'.", id)));
        }
        return this.deleteWithResponse(resourceUri, recommendationId, name, context);
    }

    private SuppressionsClient serviceClient() {
        return this.innerClient;
    }

    private AdvisorManager manager() {
        return this.serviceManager;
    }

    @Override
    public SuppressionContractImpl define(String name) {
        return new SuppressionContractImpl(name, this.manager());
    }
}

