/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.advisor.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.advisor.models.Category;
import com.azure.resourcemanager.advisor.models.DigestConfigState;
import java.io.IOException;
import java.util.List;

public final class DigestConfig
implements JsonSerializable<DigestConfig> {
    private String name;
    private String actionGroupResourceId;
    private Integer frequency;
    private List<Category> categories;
    private String language;
    private DigestConfigState state;

    public String name() {
        return this.name;
    }

    public DigestConfig withName(String name) {
        this.name = name;
        return this;
    }

    public String actionGroupResourceId() {
        return this.actionGroupResourceId;
    }

    public DigestConfig withActionGroupResourceId(String actionGroupResourceId) {
        this.actionGroupResourceId = actionGroupResourceId;
        return this;
    }

    public Integer frequency() {
        return this.frequency;
    }

    public DigestConfig withFrequency(Integer frequency) {
        this.frequency = frequency;
        return this;
    }

    public List<Category> categories() {
        return this.categories;
    }

    public DigestConfig withCategories(List<Category> categories) {
        this.categories = categories;
        return this;
    }

    public String language() {
        return this.language;
    }

    public DigestConfig withLanguage(String language) {
        this.language = language;
        return this;
    }

    public DigestConfigState state() {
        return this.state;
    }

    public DigestConfig withState(DigestConfigState state) {
        this.state = state;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("actionGroupResourceId", this.actionGroupResourceId);
        jsonWriter.writeNumberField("frequency", (Number)this.frequency);
        jsonWriter.writeArrayField("categories", this.categories, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeStringField("language", this.language);
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        return jsonWriter.writeEndObject();
    }

    public static DigestConfig fromJson(JsonReader jsonReader) throws IOException {
        return (DigestConfig)jsonReader.readObject(reader -> {
            DigestConfig deserializedDigestConfig = new DigestConfig();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedDigestConfig.name = reader.getString();
                    continue;
                }
                if ("actionGroupResourceId".equals(fieldName)) {
                    deserializedDigestConfig.actionGroupResourceId = reader.getString();
                    continue;
                }
                if ("frequency".equals(fieldName)) {
                    deserializedDigestConfig.frequency = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("categories".equals(fieldName)) {
                    List categories;
                    deserializedDigestConfig.categories = categories = reader.readArray(reader1 -> Category.fromString(reader1.getString()));
                    continue;
                }
                if ("language".equals(fieldName)) {
                    deserializedDigestConfig.language = reader.getString();
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedDigestConfig.state = DigestConfigState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDigestConfig;
        });
    }
}

