/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.advisor.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.advisor.fluent.models.OperationEntityInner;
import java.io.IOException;
import java.util.List;

public final class OperationEntityListResult
implements JsonSerializable<OperationEntityListResult> {
    private String nextLink;
    private List<OperationEntityInner> value;

    public String nextLink() {
        return this.nextLink;
    }

    public OperationEntityListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public List<OperationEntityInner> value() {
        return this.value;
    }

    public OperationEntityListResult withValue(List<OperationEntityInner> value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static OperationEntityListResult fromJson(JsonReader jsonReader) throws IOException {
        return (OperationEntityListResult)jsonReader.readObject(reader -> {
            OperationEntityListResult deserializedOperationEntityListResult = new OperationEntityListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nextLink".equals(fieldName)) {
                    deserializedOperationEntityListResult.nextLink = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedOperationEntityListResult.value = value = reader.readArray(reader1 -> OperationEntityInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOperationEntityListResult;
        });
    }
}

