/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.advisor.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class ResourceMetadata
implements JsonSerializable<ResourceMetadata> {
    private String resourceId;
    private String source;
    private Map<String, Object> action;
    private String singular;
    private String plural;

    public String resourceId() {
        return this.resourceId;
    }

    public ResourceMetadata withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public String source() {
        return this.source;
    }

    public ResourceMetadata withSource(String source) {
        this.source = source;
        return this;
    }

    public Map<String, Object> action() {
        return this.action;
    }

    public ResourceMetadata withAction(Map<String, Object> action) {
        this.action = action;
        return this;
    }

    public String singular() {
        return this.singular;
    }

    public ResourceMetadata withSingular(String singular) {
        this.singular = singular;
        return this;
    }

    public String plural() {
        return this.plural;
    }

    public ResourceMetadata withPlural(String plural) {
        this.plural = plural;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeStringField("source", this.source);
        jsonWriter.writeMapField("action", this.action, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("singular", this.singular);
        jsonWriter.writeStringField("plural", this.plural);
        return jsonWriter.writeEndObject();
    }

    public static ResourceMetadata fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceMetadata)jsonReader.readObject(reader -> {
            ResourceMetadata deserializedResourceMetadata = new ResourceMetadata();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resourceId".equals(fieldName)) {
                    deserializedResourceMetadata.resourceId = reader.getString();
                    continue;
                }
                if ("source".equals(fieldName)) {
                    deserializedResourceMetadata.source = reader.getString();
                    continue;
                }
                if ("action".equals(fieldName)) {
                    Map action;
                    deserializedResourceMetadata.action = action = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("singular".equals(fieldName)) {
                    deserializedResourceMetadata.singular = reader.getString();
                    continue;
                }
                if ("plural".equals(fieldName)) {
                    deserializedResourceMetadata.plural = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceMetadata;
        });
    }
}

