/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.advisor.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.advisor.fluent.models.ResourceRecommendationBaseInner;
import java.io.IOException;
import java.util.List;

public final class ResourceRecommendationBaseListResult
implements JsonSerializable<ResourceRecommendationBaseListResult> {
    private String nextLink;
    private List<ResourceRecommendationBaseInner> value;

    public String nextLink() {
        return this.nextLink;
    }

    public ResourceRecommendationBaseListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public List<ResourceRecommendationBaseInner> value() {
        return this.value;
    }

    public ResourceRecommendationBaseListResult withValue(List<ResourceRecommendationBaseInner> value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ResourceRecommendationBaseListResult fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceRecommendationBaseListResult)jsonReader.readObject(reader -> {
            ResourceRecommendationBaseListResult deserializedResourceRecommendationBaseListResult = new ResourceRecommendationBaseListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nextLink".equals(fieldName)) {
                    deserializedResourceRecommendationBaseListResult.nextLink = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedResourceRecommendationBaseListResult.value = value = reader.readArray(reader1 -> ResourceRecommendationBaseInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceRecommendationBaseListResult;
        });
    }
}

