/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.advisor.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.advisor.fluent.models.SuppressionContractInner;
import java.io.IOException;
import java.util.List;

public final class SuppressionContractListResult
implements JsonSerializable<SuppressionContractListResult> {
    private String nextLink;
    private List<SuppressionContractInner> value;

    public String nextLink() {
        return this.nextLink;
    }

    public SuppressionContractListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public List<SuppressionContractInner> value() {
        return this.value;
    }

    public SuppressionContractListResult withValue(List<SuppressionContractInner> value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SuppressionContractListResult fromJson(JsonReader jsonReader) throws IOException {
        return (SuppressionContractListResult)jsonReader.readObject(reader -> {
            SuppressionContractListResult deserializedSuppressionContractListResult = new SuppressionContractListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nextLink".equals(fieldName)) {
                    deserializedSuppressionContractListResult.nextLink = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedSuppressionContractListResult.value = value = reader.readArray(reader1 -> SuppressionContractInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSuppressionContractListResult;
        });
    }
}

