/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apicenter.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apicenter.ApiCenterManager;
import com.azure.resourcemanager.apicenter.fluent.models.ApiDefinitionInner;
import com.azure.resourcemanager.apicenter.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apicenter.models.ApiDefinition;
import com.azure.resourcemanager.apicenter.models.ApiDefinitionProperties;
import com.azure.resourcemanager.apicenter.models.ApiSpecExportResult;
import com.azure.resourcemanager.apicenter.models.ApiSpecImportRequest;

public final class ApiDefinitionImpl
implements ApiDefinition,
ApiDefinition.Definition,
ApiDefinition.Update {
    private ApiDefinitionInner innerObject;
    private final ApiCenterManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String workspaceName;
    private String apiName;
    private String versionName;
    private String definitionName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public ApiDefinitionProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ApiDefinitionInner innerModel() {
        return this.innerObject;
    }

    private ApiCenterManager manager() {
        return this.serviceManager;
    }

    @Override
    public ApiDefinitionImpl withExistingVersion(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        this.workspaceName = workspaceName;
        this.apiName = apiName;
        this.versionName = versionName;
        return this;
    }

    @Override
    public ApiDefinition create() {
        this.innerObject = this.serviceManager.serviceClient().getApiDefinitions().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.workspaceName, this.apiName, this.versionName, this.definitionName, this.innerModel(), Context.NONE).getValue();
        return this;
    }

    @Override
    public ApiDefinition create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApiDefinitions().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.workspaceName, this.apiName, this.versionName, this.definitionName, this.innerModel(), context).getValue();
        return this;
    }

    ApiDefinitionImpl(String name, ApiCenterManager serviceManager) {
        this.innerObject = new ApiDefinitionInner();
        this.serviceManager = serviceManager;
        this.definitionName = name;
    }

    @Override
    public ApiDefinitionImpl update() {
        return this;
    }

    @Override
    public ApiDefinition apply() {
        this.innerObject = this.serviceManager.serviceClient().getApiDefinitions().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.workspaceName, this.apiName, this.versionName, this.definitionName, this.innerModel(), Context.NONE).getValue();
        return this;
    }

    @Override
    public ApiDefinition apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApiDefinitions().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.workspaceName, this.apiName, this.versionName, this.definitionName, this.innerModel(), context).getValue();
        return this;
    }

    ApiDefinitionImpl(ApiDefinitionInner innerObject, ApiCenterManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "services");
        this.workspaceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "workspaces");
        this.apiName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "apis");
        this.versionName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "versions");
        this.definitionName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "definitions");
    }

    @Override
    public ApiDefinition refresh() {
        this.innerObject = this.serviceManager.serviceClient().getApiDefinitions().getWithResponse(this.resourceGroupName, this.serviceName, this.workspaceName, this.apiName, this.versionName, this.definitionName, Context.NONE).getValue();
        return this;
    }

    @Override
    public ApiDefinition refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApiDefinitions().getWithResponse(this.resourceGroupName, this.serviceName, this.workspaceName, this.apiName, this.versionName, this.definitionName, context).getValue();
        return this;
    }

    @Override
    public ApiSpecExportResult exportSpecification() {
        return this.serviceManager.apiDefinitions().exportSpecification(this.resourceGroupName, this.serviceName, this.workspaceName, this.apiName, this.versionName, this.definitionName);
    }

    @Override
    public ApiSpecExportResult exportSpecification(Context context) {
        return this.serviceManager.apiDefinitions().exportSpecification(this.resourceGroupName, this.serviceName, this.workspaceName, this.apiName, this.versionName, this.definitionName, context);
    }

    @Override
    public void importSpecification(ApiSpecImportRequest body) {
        this.serviceManager.apiDefinitions().importSpecification(this.resourceGroupName, this.serviceName, this.workspaceName, this.apiName, this.versionName, this.definitionName, body);
    }

    @Override
    public void importSpecification(ApiSpecImportRequest body, Context context) {
        this.serviceManager.apiDefinitions().importSpecification(this.resourceGroupName, this.serviceName, this.workspaceName, this.apiName, this.versionName, this.definitionName, body, context);
    }

    @Override
    public ApiDefinitionImpl withProperties(ApiDefinitionProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

