/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apicenter.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Head;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.apicenter.fluent.ApiDefinitionsClient;
import com.azure.resourcemanager.apicenter.fluent.models.ApiDefinitionInner;
import com.azure.resourcemanager.apicenter.fluent.models.ApiSpecExportResultInner;
import com.azure.resourcemanager.apicenter.implementation.AzureApiCenterImpl;
import com.azure.resourcemanager.apicenter.models.ApiDefinitionListResult;
import com.azure.resourcemanager.apicenter.models.ApiDefinitionsCreateOrUpdateResponse;
import com.azure.resourcemanager.apicenter.models.ApiDefinitionsGetResponse;
import com.azure.resourcemanager.apicenter.models.ApiSpecImportRequest;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ApiDefinitionsClientImpl
implements ApiDefinitionsClient {
    private final ApiDefinitionsService service;
    private final AzureApiCenterImpl client;

    ApiDefinitionsClientImpl(AzureApiCenterImpl client) {
        this.service = (ApiDefinitionsService)RestProxy.create(ApiDefinitionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ApiDefinitionInner>> listSinglePageAsync(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (apiName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiName is required and cannot be null."));
        }
        if (versionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter versionName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, workspaceName, apiName, versionName, filter, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApiDefinitionListResult)res.getValue()).value(), ((ApiDefinitionListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ApiDefinitionInner>> listSinglePageAsync(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (apiName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiName is required and cannot be null."));
        }
        if (versionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter versionName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, workspaceName, apiName, versionName, filter, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApiDefinitionListResult)res.getValue()).value(), ((ApiDefinitionListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ApiDefinitionInner> listAsync(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, String filter) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, serviceName, workspaceName, apiName, versionName, filter), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ApiDefinitionInner> listAsync(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName) {
        String filter = null;
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, serviceName, workspaceName, apiName, versionName, filter), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ApiDefinitionInner> listAsync(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, String filter, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, serviceName, workspaceName, apiName, versionName, filter, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ApiDefinitionInner> list(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName) {
        String filter = null;
        return new PagedIterable(this.listAsync(resourceGroupName, serviceName, workspaceName, apiName, versionName, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ApiDefinitionInner> list(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, String filter, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, serviceName, workspaceName, apiName, versionName, filter, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ApiDefinitionsGetResponse> getWithResponseAsync(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, String definitionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (apiName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiName is required and cannot be null."));
        }
        if (versionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter versionName is required and cannot be null."));
        }
        if (definitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter definitionName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, workspaceName, apiName, versionName, definitionName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ApiDefinitionsGetResponse> getWithResponseAsync(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, String definitionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (apiName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiName is required and cannot be null."));
        }
        if (versionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter versionName is required and cannot be null."));
        }
        if (definitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter definitionName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, workspaceName, apiName, versionName, definitionName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ApiDefinitionInner> getAsync(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, String definitionName) {
        return this.getWithResponseAsync(resourceGroupName, serviceName, workspaceName, apiName, versionName, definitionName).flatMap(res -> Mono.justOrEmpty((Object)((Object)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ApiDefinitionsGetResponse getWithResponse(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, String definitionName, Context context) {
        return (ApiDefinitionsGetResponse)((Object)this.getWithResponseAsync(resourceGroupName, serviceName, workspaceName, apiName, versionName, definitionName, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ApiDefinitionInner get(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, String definitionName) {
        return this.getWithResponse(resourceGroupName, serviceName, workspaceName, apiName, versionName, definitionName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ApiDefinitionsCreateOrUpdateResponse> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, String definitionName, ApiDefinitionInner resource) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (apiName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiName is required and cannot be null."));
        }
        if (versionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter versionName is required and cannot be null."));
        }
        if (definitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter definitionName is required and cannot be null."));
        }
        if (resource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resource is required and cannot be null."));
        }
        resource.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, workspaceName, apiName, versionName, definitionName, resource, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ApiDefinitionsCreateOrUpdateResponse> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, String definitionName, ApiDefinitionInner resource, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (apiName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiName is required and cannot be null."));
        }
        if (versionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter versionName is required and cannot be null."));
        }
        if (definitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter definitionName is required and cannot be null."));
        }
        if (resource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resource is required and cannot be null."));
        }
        resource.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, workspaceName, apiName, versionName, definitionName, resource, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ApiDefinitionInner> createOrUpdateAsync(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, String definitionName, ApiDefinitionInner resource) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, workspaceName, apiName, versionName, definitionName, resource).flatMap(res -> Mono.justOrEmpty((Object)((Object)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ApiDefinitionsCreateOrUpdateResponse createOrUpdateWithResponse(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, String definitionName, ApiDefinitionInner resource, Context context) {
        return (ApiDefinitionsCreateOrUpdateResponse)((Object)this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, workspaceName, apiName, versionName, definitionName, resource, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ApiDefinitionInner createOrUpdate(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, String definitionName, ApiDefinitionInner resource) {
        return this.createOrUpdateWithResponse(resourceGroupName, serviceName, workspaceName, apiName, versionName, definitionName, resource, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, String definitionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (apiName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiName is required and cannot be null."));
        }
        if (versionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter versionName is required and cannot be null."));
        }
        if (definitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter definitionName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, workspaceName, apiName, versionName, definitionName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, String definitionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (apiName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiName is required and cannot be null."));
        }
        if (versionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter versionName is required and cannot be null."));
        }
        if (definitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter definitionName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, workspaceName, apiName, versionName, definitionName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, String definitionName) {
        return this.deleteWithResponseAsync(resourceGroupName, serviceName, workspaceName, apiName, versionName, definitionName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, String definitionName, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, serviceName, workspaceName, apiName, versionName, definitionName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, String definitionName) {
        this.deleteWithResponse(resourceGroupName, serviceName, workspaceName, apiName, versionName, definitionName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> headWithResponseAsync(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, String definitionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (apiName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiName is required and cannot be null."));
        }
        if (versionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter versionName is required and cannot be null."));
        }
        if (definitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter definitionName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.head(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, workspaceName, apiName, versionName, definitionName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> headWithResponseAsync(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, String definitionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (apiName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiName is required and cannot be null."));
        }
        if (versionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter versionName is required and cannot be null."));
        }
        if (definitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter definitionName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.head(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, workspaceName, apiName, versionName, definitionName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> headAsync(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, String definitionName) {
        return this.headWithResponseAsync(resourceGroupName, serviceName, workspaceName, apiName, versionName, definitionName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> headWithResponse(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, String definitionName, Context context) {
        return (Response)this.headWithResponseAsync(resourceGroupName, serviceName, workspaceName, apiName, versionName, definitionName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void head(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, String definitionName) {
        this.headWithResponse(resourceGroupName, serviceName, workspaceName, apiName, versionName, definitionName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> exportSpecificationWithResponseAsync(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, String definitionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (apiName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiName is required and cannot be null."));
        }
        if (versionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter versionName is required and cannot be null."));
        }
        if (definitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter definitionName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.exportSpecification(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, workspaceName, apiName, versionName, definitionName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> exportSpecificationWithResponseAsync(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, String definitionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (apiName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiName is required and cannot be null."));
        }
        if (versionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter versionName is required and cannot be null."));
        }
        if (definitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter definitionName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.exportSpecification(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, workspaceName, apiName, versionName, definitionName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ApiSpecExportResultInner>, ApiSpecExportResultInner> beginExportSpecificationAsync(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, String definitionName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.exportSpecificationWithResponseAsync(resourceGroupName, serviceName, workspaceName, apiName, versionName, definitionName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ApiSpecExportResultInner.class), (Type)((Object)ApiSpecExportResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ApiSpecExportResultInner>, ApiSpecExportResultInner> beginExportSpecificationAsync(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, String definitionName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.exportSpecificationWithResponseAsync(resourceGroupName, serviceName, workspaceName, apiName, versionName, definitionName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ApiSpecExportResultInner.class), (Type)((Object)ApiSpecExportResultInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ApiSpecExportResultInner>, ApiSpecExportResultInner> beginExportSpecification(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, String definitionName) {
        return this.beginExportSpecificationAsync(resourceGroupName, serviceName, workspaceName, apiName, versionName, definitionName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ApiSpecExportResultInner>, ApiSpecExportResultInner> beginExportSpecification(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, String definitionName, Context context) {
        return this.beginExportSpecificationAsync(resourceGroupName, serviceName, workspaceName, apiName, versionName, definitionName, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ApiSpecExportResultInner> exportSpecificationAsync(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, String definitionName) {
        return this.beginExportSpecificationAsync(resourceGroupName, serviceName, workspaceName, apiName, versionName, definitionName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ApiSpecExportResultInner> exportSpecificationAsync(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, String definitionName, Context context) {
        return this.beginExportSpecificationAsync(resourceGroupName, serviceName, workspaceName, apiName, versionName, definitionName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ApiSpecExportResultInner exportSpecification(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, String definitionName) {
        return (ApiSpecExportResultInner)this.exportSpecificationAsync(resourceGroupName, serviceName, workspaceName, apiName, versionName, definitionName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ApiSpecExportResultInner exportSpecification(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, String definitionName, Context context) {
        return (ApiSpecExportResultInner)this.exportSpecificationAsync(resourceGroupName, serviceName, workspaceName, apiName, versionName, definitionName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> importSpecificationWithResponseAsync(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, String definitionName, ApiSpecImportRequest body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (apiName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiName is required and cannot be null."));
        }
        if (versionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter versionName is required and cannot be null."));
        }
        if (definitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter definitionName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.importSpecification(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, workspaceName, apiName, versionName, definitionName, body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> importSpecificationWithResponseAsync(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, String definitionName, ApiSpecImportRequest body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (apiName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiName is required and cannot be null."));
        }
        if (versionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter versionName is required and cannot be null."));
        }
        if (definitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter definitionName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.importSpecification(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, workspaceName, apiName, versionName, definitionName, body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginImportSpecificationAsync(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, String definitionName, ApiSpecImportRequest body) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.importSpecificationWithResponseAsync(resourceGroupName, serviceName, workspaceName, apiName, versionName, definitionName, body);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginImportSpecificationAsync(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, String definitionName, ApiSpecImportRequest body, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.importSpecificationWithResponseAsync(resourceGroupName, serviceName, workspaceName, apiName, versionName, definitionName, body, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginImportSpecification(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, String definitionName, ApiSpecImportRequest body) {
        return this.beginImportSpecificationAsync(resourceGroupName, serviceName, workspaceName, apiName, versionName, definitionName, body).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginImportSpecification(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, String definitionName, ApiSpecImportRequest body, Context context) {
        return this.beginImportSpecificationAsync(resourceGroupName, serviceName, workspaceName, apiName, versionName, definitionName, body, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> importSpecificationAsync(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, String definitionName, ApiSpecImportRequest body) {
        return this.beginImportSpecificationAsync(resourceGroupName, serviceName, workspaceName, apiName, versionName, definitionName, body).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> importSpecificationAsync(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, String definitionName, ApiSpecImportRequest body, Context context) {
        return this.beginImportSpecificationAsync(resourceGroupName, serviceName, workspaceName, apiName, versionName, definitionName, body, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void importSpecification(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, String definitionName, ApiSpecImportRequest body) {
        this.importSpecificationAsync(resourceGroupName, serviceName, workspaceName, apiName, versionName, definitionName, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void importSpecification(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, String definitionName, ApiSpecImportRequest body, Context context) {
        this.importSpecificationAsync(resourceGroupName, serviceName, workspaceName, apiName, versionName, definitionName, body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ApiDefinitionInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApiDefinitionListResult)res.getValue()).value(), ((ApiDefinitionListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ApiDefinitionInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApiDefinitionListResult)res.getValue()).value(), ((ApiDefinitionListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AzureApiCenterApiDef")
    public static interface ApiDefinitionsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiCenter/services/{serviceName}/workspaces/{workspaceName}/apis/{apiName}/versions/{versionName}/definitions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ApiDefinitionListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="workspaceName") String var6, @PathParam(value="apiName") String var7, @PathParam(value="versionName") String var8, @QueryParam(value="$filter") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiCenter/services/{serviceName}/workspaces/{workspaceName}/apis/{apiName}/versions/{versionName}/definitions/{definitionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<ApiDefinitionsGetResponse> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="workspaceName") String var6, @PathParam(value="apiName") String var7, @PathParam(value="versionName") String var8, @PathParam(value="definitionName") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiCenter/services/{serviceName}/workspaces/{workspaceName}/apis/{apiName}/versions/{versionName}/definitions/{definitionName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<ApiDefinitionsCreateOrUpdateResponse> createOrUpdate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="workspaceName") String var6, @PathParam(value="apiName") String var7, @PathParam(value="versionName") String var8, @PathParam(value="definitionName") String var9, @BodyParam(value="application/json") ApiDefinitionInner var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiCenter/services/{serviceName}/workspaces/{workspaceName}/apis/{apiName}/versions/{versionName}/definitions/{definitionName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="workspaceName") String var6, @PathParam(value="apiName") String var7, @PathParam(value="versionName") String var8, @PathParam(value="definitionName") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Head(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiCenter/services/{serviceName}/workspaces/{workspaceName}/apis/{apiName}/versions/{versionName}/definitions/{definitionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> head(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="workspaceName") String var6, @PathParam(value="apiName") String var7, @PathParam(value="versionName") String var8, @PathParam(value="definitionName") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiCenter/services/{serviceName}/workspaces/{workspaceName}/apis/{apiName}/versions/{versionName}/definitions/{definitionName}/exportSpecification")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> exportSpecification(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="workspaceName") String var6, @PathParam(value="apiName") String var7, @PathParam(value="versionName") String var8, @PathParam(value="definitionName") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiCenter/services/{serviceName}/workspaces/{workspaceName}/apis/{apiName}/versions/{versionName}/definitions/{definitionName}/importSpecification")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> importSpecification(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="workspaceName") String var6, @PathParam(value="apiName") String var7, @PathParam(value="versionName") String var8, @PathParam(value="definitionName") String var9, @BodyParam(value="application/json") ApiSpecImportRequest var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ApiDefinitionListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

