/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apicenter.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apicenter.ApiCenterManager;
import com.azure.resourcemanager.apicenter.fluent.models.ApiInner;
import com.azure.resourcemanager.apicenter.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apicenter.models.Api;
import com.azure.resourcemanager.apicenter.models.ApiProperties;

public final class ApiImpl
implements Api,
Api.Definition,
Api.Update {
    private ApiInner innerObject;
    private final ApiCenterManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String workspaceName;
    private String apiName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public ApiProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ApiInner innerModel() {
        return this.innerObject;
    }

    private ApiCenterManager manager() {
        return this.serviceManager;
    }

    @Override
    public ApiImpl withExistingWorkspace(String resourceGroupName, String serviceName, String workspaceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        this.workspaceName = workspaceName;
        return this;
    }

    @Override
    public Api create() {
        this.innerObject = this.serviceManager.serviceClient().getApis().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.workspaceName, this.apiName, this.innerModel(), Context.NONE).getValue();
        return this;
    }

    @Override
    public Api create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApis().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.workspaceName, this.apiName, this.innerModel(), context).getValue();
        return this;
    }

    ApiImpl(String name, ApiCenterManager serviceManager) {
        this.innerObject = new ApiInner();
        this.serviceManager = serviceManager;
        this.apiName = name;
    }

    @Override
    public ApiImpl update() {
        return this;
    }

    @Override
    public Api apply() {
        this.innerObject = this.serviceManager.serviceClient().getApis().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.workspaceName, this.apiName, this.innerModel(), Context.NONE).getValue();
        return this;
    }

    @Override
    public Api apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApis().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.workspaceName, this.apiName, this.innerModel(), context).getValue();
        return this;
    }

    ApiImpl(ApiInner innerObject, ApiCenterManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "services");
        this.workspaceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "workspaces");
        this.apiName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "apis");
    }

    @Override
    public Api refresh() {
        this.innerObject = this.serviceManager.serviceClient().getApis().getWithResponse(this.resourceGroupName, this.serviceName, this.workspaceName, this.apiName, Context.NONE).getValue();
        return this;
    }

    @Override
    public Api refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApis().getWithResponse(this.resourceGroupName, this.serviceName, this.workspaceName, this.apiName, context).getValue();
        return this;
    }

    @Override
    public ApiImpl withProperties(ApiProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

