/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apicenter.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apicenter.ApiCenterManager;
import com.azure.resourcemanager.apicenter.fluent.models.ApiVersionInner;
import com.azure.resourcemanager.apicenter.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apicenter.models.ApiVersion;
import com.azure.resourcemanager.apicenter.models.ApiVersionProperties;

public final class ApiVersionImpl
implements ApiVersion,
ApiVersion.Definition,
ApiVersion.Update {
    private ApiVersionInner innerObject;
    private final ApiCenterManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String workspaceName;
    private String apiName;
    private String versionName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public ApiVersionProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ApiVersionInner innerModel() {
        return this.innerObject;
    }

    private ApiCenterManager manager() {
        return this.serviceManager;
    }

    @Override
    public ApiVersionImpl withExistingApi(String resourceGroupName, String serviceName, String workspaceName, String apiName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        this.workspaceName = workspaceName;
        this.apiName = apiName;
        return this;
    }

    @Override
    public ApiVersion create() {
        this.innerObject = this.serviceManager.serviceClient().getApiVersions().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.workspaceName, this.apiName, this.versionName, this.innerModel(), Context.NONE).getValue();
        return this;
    }

    @Override
    public ApiVersion create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApiVersions().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.workspaceName, this.apiName, this.versionName, this.innerModel(), context).getValue();
        return this;
    }

    ApiVersionImpl(String name, ApiCenterManager serviceManager) {
        this.innerObject = new ApiVersionInner();
        this.serviceManager = serviceManager;
        this.versionName = name;
    }

    @Override
    public ApiVersionImpl update() {
        return this;
    }

    @Override
    public ApiVersion apply() {
        this.innerObject = this.serviceManager.serviceClient().getApiVersions().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.workspaceName, this.apiName, this.versionName, this.innerModel(), Context.NONE).getValue();
        return this;
    }

    @Override
    public ApiVersion apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApiVersions().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.workspaceName, this.apiName, this.versionName, this.innerModel(), context).getValue();
        return this;
    }

    ApiVersionImpl(ApiVersionInner innerObject, ApiCenterManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "services");
        this.workspaceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "workspaces");
        this.apiName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "apis");
        this.versionName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "versions");
    }

    @Override
    public ApiVersion refresh() {
        this.innerObject = this.serviceManager.serviceClient().getApiVersions().getWithResponse(this.resourceGroupName, this.serviceName, this.workspaceName, this.apiName, this.versionName, Context.NONE).getValue();
        return this;
    }

    @Override
    public ApiVersion refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getApiVersions().getWithResponse(this.resourceGroupName, this.serviceName, this.workspaceName, this.apiName, this.versionName, context).getValue();
        return this;
    }

    @Override
    public ApiVersionImpl withProperties(ApiVersionProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

