/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apicenter.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apicenter.ApiCenterManager;
import com.azure.resourcemanager.apicenter.fluent.ApiVersionsClient;
import com.azure.resourcemanager.apicenter.fluent.models.ApiVersionInner;
import com.azure.resourcemanager.apicenter.implementation.ApiVersionImpl;
import com.azure.resourcemanager.apicenter.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apicenter.models.ApiVersion;
import com.azure.resourcemanager.apicenter.models.ApiVersions;
import com.azure.resourcemanager.apicenter.models.ApiVersionsGetResponse;

public final class ApiVersionsImpl
implements ApiVersions {
    private static final ClientLogger LOGGER = new ClientLogger(ApiVersionsImpl.class);
    private final ApiVersionsClient innerClient;
    private final ApiCenterManager serviceManager;

    public ApiVersionsImpl(ApiVersionsClient innerClient, ApiCenterManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ApiVersion> list(String resourceGroupName, String serviceName, String workspaceName, String apiName) {
        PagedIterable<ApiVersionInner> inner = this.serviceClient().list(resourceGroupName, serviceName, workspaceName, apiName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiVersionImpl((ApiVersionInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ApiVersion> list(String resourceGroupName, String serviceName, String workspaceName, String apiName, String filter, Context context) {
        PagedIterable<ApiVersionInner> inner = this.serviceClient().list(resourceGroupName, serviceName, workspaceName, apiName, filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiVersionImpl((ApiVersionInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<ApiVersion> getWithResponse(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, Context context) {
        ApiVersionsGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, workspaceName, apiName, versionName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ApiVersionImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ApiVersion get(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName) {
        ApiVersionInner inner = this.serviceClient().get(resourceGroupName, serviceName, workspaceName, apiName, versionName);
        if (inner != null) {
            return new ApiVersionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, workspaceName, apiName, versionName, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName) {
        this.serviceClient().delete(resourceGroupName, serviceName, workspaceName, apiName, versionName);
    }

    @Override
    public Response<Void> headWithResponse(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName, Context context) {
        return this.serviceClient().headWithResponse(resourceGroupName, serviceName, workspaceName, apiName, versionName, context);
    }

    @Override
    public void head(String resourceGroupName, String serviceName, String workspaceName, String apiName, String versionName) {
        this.serviceClient().head(resourceGroupName, serviceName, workspaceName, apiName, versionName);
    }

    @Override
    public ApiVersion getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "services");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'services'.", id)));
        }
        String workspaceName = ResourceManagerUtils.getValueFromIdByName(id, "workspaces");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        String apiName = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String versionName = ResourceManagerUtils.getValueFromIdByName(id, "versions");
        if (versionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'versions'.", id)));
        }
        return (ApiVersion)this.getWithResponse(resourceGroupName, serviceName, workspaceName, apiName, versionName, Context.NONE).getValue();
    }

    @Override
    public Response<ApiVersion> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "services");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'services'.", id)));
        }
        String workspaceName = ResourceManagerUtils.getValueFromIdByName(id, "workspaces");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        String apiName = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String versionName = ResourceManagerUtils.getValueFromIdByName(id, "versions");
        if (versionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'versions'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, workspaceName, apiName, versionName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "services");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'services'.", id)));
        }
        String workspaceName = ResourceManagerUtils.getValueFromIdByName(id, "workspaces");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        String apiName = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String versionName = ResourceManagerUtils.getValueFromIdByName(id, "versions");
        if (versionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'versions'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, serviceName, workspaceName, apiName, versionName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "services");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'services'.", id)));
        }
        String workspaceName = ResourceManagerUtils.getValueFromIdByName(id, "workspaces");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        String apiName = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String versionName = ResourceManagerUtils.getValueFromIdByName(id, "versions");
        if (versionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'versions'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, workspaceName, apiName, versionName, context);
    }

    private ApiVersionsClient serviceClient() {
        return this.innerClient;
    }

    private ApiCenterManager manager() {
        return this.serviceManager;
    }

    @Override
    public ApiVersionImpl define(String name) {
        return new ApiVersionImpl(name, this.manager());
    }
}

