/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apicenter.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apicenter.ApiCenterManager;
import com.azure.resourcemanager.apicenter.fluent.ApisClient;
import com.azure.resourcemanager.apicenter.fluent.models.ApiInner;
import com.azure.resourcemanager.apicenter.implementation.ApiImpl;
import com.azure.resourcemanager.apicenter.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apicenter.models.Api;
import com.azure.resourcemanager.apicenter.models.Apis;
import com.azure.resourcemanager.apicenter.models.ApisGetResponse;

public final class ApisImpl
implements Apis {
    private static final ClientLogger LOGGER = new ClientLogger(ApisImpl.class);
    private final ApisClient innerClient;
    private final ApiCenterManager serviceManager;

    public ApisImpl(ApisClient innerClient, ApiCenterManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Api> list(String resourceGroupName, String serviceName, String workspaceName) {
        PagedIterable<ApiInner> inner = this.serviceClient().list(resourceGroupName, serviceName, workspaceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiImpl((ApiInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Api> list(String resourceGroupName, String serviceName, String workspaceName, String filter, Context context) {
        PagedIterable<ApiInner> inner = this.serviceClient().list(resourceGroupName, serviceName, workspaceName, filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiImpl((ApiInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<Api> getWithResponse(String resourceGroupName, String serviceName, String workspaceName, String apiName, Context context) {
        ApisGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, workspaceName, apiName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ApiImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public Api get(String resourceGroupName, String serviceName, String workspaceName, String apiName) {
        ApiInner inner = this.serviceClient().get(resourceGroupName, serviceName, workspaceName, apiName);
        if (inner != null) {
            return new ApiImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String workspaceName, String apiName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, workspaceName, apiName, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String workspaceName, String apiName) {
        this.serviceClient().delete(resourceGroupName, serviceName, workspaceName, apiName);
    }

    @Override
    public Response<Void> headWithResponse(String resourceGroupName, String serviceName, String workspaceName, String apiName, Context context) {
        return this.serviceClient().headWithResponse(resourceGroupName, serviceName, workspaceName, apiName, context);
    }

    @Override
    public void head(String resourceGroupName, String serviceName, String workspaceName, String apiName) {
        this.serviceClient().head(resourceGroupName, serviceName, workspaceName, apiName);
    }

    @Override
    public Api getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "services");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'services'.", id)));
        }
        String workspaceName = ResourceManagerUtils.getValueFromIdByName(id, "workspaces");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        String apiName = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        return (Api)this.getWithResponse(resourceGroupName, serviceName, workspaceName, apiName, Context.NONE).getValue();
    }

    @Override
    public Response<Api> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "services");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'services'.", id)));
        }
        String workspaceName = ResourceManagerUtils.getValueFromIdByName(id, "workspaces");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        String apiName = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, workspaceName, apiName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "services");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'services'.", id)));
        }
        String workspaceName = ResourceManagerUtils.getValueFromIdByName(id, "workspaces");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        String apiName = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, serviceName, workspaceName, apiName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "services");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'services'.", id)));
        }
        String workspaceName = ResourceManagerUtils.getValueFromIdByName(id, "workspaces");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        String apiName = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, workspaceName, apiName, context);
    }

    private ApisClient serviceClient() {
        return this.innerClient;
    }

    private ApiCenterManager manager() {
        return this.serviceManager;
    }

    @Override
    public ApiImpl define(String name) {
        return new ApiImpl(name, this.manager());
    }
}

