/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apicenter.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apicenter.ApiCenterManager;
import com.azure.resourcemanager.apicenter.fluent.models.DeploymentInner;
import com.azure.resourcemanager.apicenter.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apicenter.models.Deployment;
import com.azure.resourcemanager.apicenter.models.DeploymentProperties;

public final class DeploymentImpl
implements Deployment,
Deployment.Definition,
Deployment.Update {
    private DeploymentInner innerObject;
    private final ApiCenterManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String workspaceName;
    private String apiName;
    private String deploymentName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public DeploymentProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public DeploymentInner innerModel() {
        return this.innerObject;
    }

    private ApiCenterManager manager() {
        return this.serviceManager;
    }

    @Override
    public DeploymentImpl withExistingApi(String resourceGroupName, String serviceName, String workspaceName, String apiName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        this.workspaceName = workspaceName;
        this.apiName = apiName;
        return this;
    }

    @Override
    public Deployment create() {
        this.innerObject = this.serviceManager.serviceClient().getDeployments().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.workspaceName, this.apiName, this.deploymentName, this.innerModel(), Context.NONE).getValue();
        return this;
    }

    @Override
    public Deployment create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDeployments().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.workspaceName, this.apiName, this.deploymentName, this.innerModel(), context).getValue();
        return this;
    }

    DeploymentImpl(String name, ApiCenterManager serviceManager) {
        this.innerObject = new DeploymentInner();
        this.serviceManager = serviceManager;
        this.deploymentName = name;
    }

    @Override
    public DeploymentImpl update() {
        return this;
    }

    @Override
    public Deployment apply() {
        this.innerObject = this.serviceManager.serviceClient().getDeployments().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.workspaceName, this.apiName, this.deploymentName, this.innerModel(), Context.NONE).getValue();
        return this;
    }

    @Override
    public Deployment apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDeployments().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.workspaceName, this.apiName, this.deploymentName, this.innerModel(), context).getValue();
        return this;
    }

    DeploymentImpl(DeploymentInner innerObject, ApiCenterManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "services");
        this.workspaceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "workspaces");
        this.apiName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "apis");
        this.deploymentName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "deployments");
    }

    @Override
    public Deployment refresh() {
        this.innerObject = this.serviceManager.serviceClient().getDeployments().getWithResponse(this.resourceGroupName, this.serviceName, this.workspaceName, this.apiName, this.deploymentName, Context.NONE).getValue();
        return this;
    }

    @Override
    public Deployment refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDeployments().getWithResponse(this.resourceGroupName, this.serviceName, this.workspaceName, this.apiName, this.deploymentName, context).getValue();
        return this;
    }

    @Override
    public DeploymentImpl withProperties(DeploymentProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

