/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apicenter.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apicenter.ApiCenterManager;
import com.azure.resourcemanager.apicenter.fluent.DeploymentsClient;
import com.azure.resourcemanager.apicenter.fluent.models.DeploymentInner;
import com.azure.resourcemanager.apicenter.implementation.DeploymentImpl;
import com.azure.resourcemanager.apicenter.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apicenter.models.Deployment;
import com.azure.resourcemanager.apicenter.models.Deployments;
import com.azure.resourcemanager.apicenter.models.DeploymentsGetResponse;

public final class DeploymentsImpl
implements Deployments {
    private static final ClientLogger LOGGER = new ClientLogger(DeploymentsImpl.class);
    private final DeploymentsClient innerClient;
    private final ApiCenterManager serviceManager;

    public DeploymentsImpl(DeploymentsClient innerClient, ApiCenterManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Deployment> list(String resourceGroupName, String serviceName, String workspaceName, String apiName) {
        PagedIterable<DeploymentInner> inner = this.serviceClient().list(resourceGroupName, serviceName, workspaceName, apiName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DeploymentImpl((DeploymentInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Deployment> list(String resourceGroupName, String serviceName, String workspaceName, String apiName, String filter, Context context) {
        PagedIterable<DeploymentInner> inner = this.serviceClient().list(resourceGroupName, serviceName, workspaceName, apiName, filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DeploymentImpl((DeploymentInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<Deployment> getWithResponse(String resourceGroupName, String serviceName, String workspaceName, String apiName, String deploymentName, Context context) {
        DeploymentsGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, workspaceName, apiName, deploymentName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DeploymentImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public Deployment get(String resourceGroupName, String serviceName, String workspaceName, String apiName, String deploymentName) {
        DeploymentInner inner = this.serviceClient().get(resourceGroupName, serviceName, workspaceName, apiName, deploymentName);
        if (inner != null) {
            return new DeploymentImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String workspaceName, String apiName, String deploymentName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, workspaceName, apiName, deploymentName, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String workspaceName, String apiName, String deploymentName) {
        this.serviceClient().delete(resourceGroupName, serviceName, workspaceName, apiName, deploymentName);
    }

    @Override
    public Response<Void> headWithResponse(String resourceGroupName, String serviceName, String workspaceName, String apiName, String deploymentName, Context context) {
        return this.serviceClient().headWithResponse(resourceGroupName, serviceName, workspaceName, apiName, deploymentName, context);
    }

    @Override
    public void head(String resourceGroupName, String serviceName, String workspaceName, String apiName, String deploymentName) {
        this.serviceClient().head(resourceGroupName, serviceName, workspaceName, apiName, deploymentName);
    }

    @Override
    public Deployment getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "services");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'services'.", id)));
        }
        String workspaceName = ResourceManagerUtils.getValueFromIdByName(id, "workspaces");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        String apiName = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String deploymentName = ResourceManagerUtils.getValueFromIdByName(id, "deployments");
        if (deploymentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'deployments'.", id)));
        }
        return (Deployment)this.getWithResponse(resourceGroupName, serviceName, workspaceName, apiName, deploymentName, Context.NONE).getValue();
    }

    @Override
    public Response<Deployment> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "services");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'services'.", id)));
        }
        String workspaceName = ResourceManagerUtils.getValueFromIdByName(id, "workspaces");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        String apiName = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String deploymentName = ResourceManagerUtils.getValueFromIdByName(id, "deployments");
        if (deploymentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'deployments'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, workspaceName, apiName, deploymentName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "services");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'services'.", id)));
        }
        String workspaceName = ResourceManagerUtils.getValueFromIdByName(id, "workspaces");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        String apiName = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String deploymentName = ResourceManagerUtils.getValueFromIdByName(id, "deployments");
        if (deploymentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'deployments'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, serviceName, workspaceName, apiName, deploymentName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "services");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'services'.", id)));
        }
        String workspaceName = ResourceManagerUtils.getValueFromIdByName(id, "workspaces");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        String apiName = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String deploymentName = ResourceManagerUtils.getValueFromIdByName(id, "deployments");
        if (deploymentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'deployments'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, workspaceName, apiName, deploymentName, context);
    }

    private DeploymentsClient serviceClient() {
        return this.innerClient;
    }

    private ApiCenterManager manager() {
        return this.serviceManager;
    }

    @Override
    public DeploymentImpl define(String name) {
        return new DeploymentImpl(name, this.manager());
    }
}

