/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apicenter.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apicenter.ApiCenterManager;
import com.azure.resourcemanager.apicenter.fluent.models.EnvironmentInner;
import com.azure.resourcemanager.apicenter.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apicenter.models.Environment;
import com.azure.resourcemanager.apicenter.models.EnvironmentProperties;

public final class EnvironmentImpl
implements Environment,
Environment.Definition,
Environment.Update {
    private EnvironmentInner innerObject;
    private final ApiCenterManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String workspaceName;
    private String environmentName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public EnvironmentProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public EnvironmentInner innerModel() {
        return this.innerObject;
    }

    private ApiCenterManager manager() {
        return this.serviceManager;
    }

    @Override
    public EnvironmentImpl withExistingWorkspace(String resourceGroupName, String serviceName, String workspaceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        this.workspaceName = workspaceName;
        return this;
    }

    @Override
    public Environment create() {
        this.innerObject = this.serviceManager.serviceClient().getEnvironments().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.workspaceName, this.environmentName, this.innerModel(), Context.NONE).getValue();
        return this;
    }

    @Override
    public Environment create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getEnvironments().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.workspaceName, this.environmentName, this.innerModel(), context).getValue();
        return this;
    }

    EnvironmentImpl(String name, ApiCenterManager serviceManager) {
        this.innerObject = new EnvironmentInner();
        this.serviceManager = serviceManager;
        this.environmentName = name;
    }

    @Override
    public EnvironmentImpl update() {
        return this;
    }

    @Override
    public Environment apply() {
        this.innerObject = this.serviceManager.serviceClient().getEnvironments().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.workspaceName, this.environmentName, this.innerModel(), Context.NONE).getValue();
        return this;
    }

    @Override
    public Environment apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getEnvironments().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.workspaceName, this.environmentName, this.innerModel(), context).getValue();
        return this;
    }

    EnvironmentImpl(EnvironmentInner innerObject, ApiCenterManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "services");
        this.workspaceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "workspaces");
        this.environmentName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "environments");
    }

    @Override
    public Environment refresh() {
        this.innerObject = this.serviceManager.serviceClient().getEnvironments().getWithResponse(this.resourceGroupName, this.serviceName, this.workspaceName, this.environmentName, Context.NONE).getValue();
        return this;
    }

    @Override
    public Environment refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getEnvironments().getWithResponse(this.resourceGroupName, this.serviceName, this.workspaceName, this.environmentName, context).getValue();
        return this;
    }

    @Override
    public EnvironmentImpl withProperties(EnvironmentProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

