/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apicenter.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apicenter.ApiCenterManager;
import com.azure.resourcemanager.apicenter.fluent.EnvironmentsClient;
import com.azure.resourcemanager.apicenter.fluent.models.EnvironmentInner;
import com.azure.resourcemanager.apicenter.implementation.EnvironmentImpl;
import com.azure.resourcemanager.apicenter.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apicenter.models.Environment;
import com.azure.resourcemanager.apicenter.models.Environments;
import com.azure.resourcemanager.apicenter.models.EnvironmentsGetResponse;

public final class EnvironmentsImpl
implements Environments {
    private static final ClientLogger LOGGER = new ClientLogger(EnvironmentsImpl.class);
    private final EnvironmentsClient innerClient;
    private final ApiCenterManager serviceManager;

    public EnvironmentsImpl(EnvironmentsClient innerClient, ApiCenterManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Environment> list(String resourceGroupName, String serviceName, String workspaceName) {
        PagedIterable<EnvironmentInner> inner = this.serviceClient().list(resourceGroupName, serviceName, workspaceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new EnvironmentImpl((EnvironmentInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Environment> list(String resourceGroupName, String serviceName, String workspaceName, String filter, Context context) {
        PagedIterable<EnvironmentInner> inner = this.serviceClient().list(resourceGroupName, serviceName, workspaceName, filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new EnvironmentImpl((EnvironmentInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<Environment> getWithResponse(String resourceGroupName, String serviceName, String workspaceName, String environmentName, Context context) {
        EnvironmentsGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, workspaceName, environmentName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new EnvironmentImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public Environment get(String resourceGroupName, String serviceName, String workspaceName, String environmentName) {
        EnvironmentInner inner = this.serviceClient().get(resourceGroupName, serviceName, workspaceName, environmentName);
        if (inner != null) {
            return new EnvironmentImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String workspaceName, String environmentName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, workspaceName, environmentName, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String workspaceName, String environmentName) {
        this.serviceClient().delete(resourceGroupName, serviceName, workspaceName, environmentName);
    }

    @Override
    public Response<Void> headWithResponse(String resourceGroupName, String serviceName, String workspaceName, String environmentName, Context context) {
        return this.serviceClient().headWithResponse(resourceGroupName, serviceName, workspaceName, environmentName, context);
    }

    @Override
    public void head(String resourceGroupName, String serviceName, String workspaceName, String environmentName) {
        this.serviceClient().head(resourceGroupName, serviceName, workspaceName, environmentName);
    }

    @Override
    public Environment getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "services");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'services'.", id)));
        }
        String workspaceName = ResourceManagerUtils.getValueFromIdByName(id, "workspaces");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        String environmentName = ResourceManagerUtils.getValueFromIdByName(id, "environments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'environments'.", id)));
        }
        return (Environment)this.getWithResponse(resourceGroupName, serviceName, workspaceName, environmentName, Context.NONE).getValue();
    }

    @Override
    public Response<Environment> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "services");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'services'.", id)));
        }
        String workspaceName = ResourceManagerUtils.getValueFromIdByName(id, "workspaces");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        String environmentName = ResourceManagerUtils.getValueFromIdByName(id, "environments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'environments'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, workspaceName, environmentName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "services");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'services'.", id)));
        }
        String workspaceName = ResourceManagerUtils.getValueFromIdByName(id, "workspaces");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        String environmentName = ResourceManagerUtils.getValueFromIdByName(id, "environments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'environments'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, serviceName, workspaceName, environmentName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "services");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'services'.", id)));
        }
        String workspaceName = ResourceManagerUtils.getValueFromIdByName(id, "workspaces");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        String environmentName = ResourceManagerUtils.getValueFromIdByName(id, "environments");
        if (environmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'environments'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, workspaceName, environmentName, context);
    }

    private EnvironmentsClient serviceClient() {
        return this.innerClient;
    }

    private ApiCenterManager manager() {
        return this.serviceManager;
    }

    @Override
    public EnvironmentImpl define(String name) {
        return new EnvironmentImpl(name, this.manager());
    }
}

