/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apicenter.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apicenter.ApiCenterManager;
import com.azure.resourcemanager.apicenter.fluent.models.MetadataSchemaInner;
import com.azure.resourcemanager.apicenter.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apicenter.models.MetadataSchema;
import com.azure.resourcemanager.apicenter.models.MetadataSchemaProperties;

public final class MetadataSchemaImpl
implements MetadataSchema,
MetadataSchema.Definition,
MetadataSchema.Update {
    private MetadataSchemaInner innerObject;
    private final ApiCenterManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String metadataSchemaName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public MetadataSchemaProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public MetadataSchemaInner innerModel() {
        return this.innerObject;
    }

    private ApiCenterManager manager() {
        return this.serviceManager;
    }

    @Override
    public MetadataSchemaImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    @Override
    public MetadataSchema create() {
        this.innerObject = this.serviceManager.serviceClient().getMetadataSchemas().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.metadataSchemaName, this.innerModel(), Context.NONE).getValue();
        return this;
    }

    @Override
    public MetadataSchema create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getMetadataSchemas().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.metadataSchemaName, this.innerModel(), context).getValue();
        return this;
    }

    MetadataSchemaImpl(String name, ApiCenterManager serviceManager) {
        this.innerObject = new MetadataSchemaInner();
        this.serviceManager = serviceManager;
        this.metadataSchemaName = name;
    }

    @Override
    public MetadataSchemaImpl update() {
        return this;
    }

    @Override
    public MetadataSchema apply() {
        this.innerObject = this.serviceManager.serviceClient().getMetadataSchemas().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.metadataSchemaName, this.innerModel(), Context.NONE).getValue();
        return this;
    }

    @Override
    public MetadataSchema apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getMetadataSchemas().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.metadataSchemaName, this.innerModel(), context).getValue();
        return this;
    }

    MetadataSchemaImpl(MetadataSchemaInner innerObject, ApiCenterManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "services");
        this.metadataSchemaName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "metadataSchemas");
    }

    @Override
    public MetadataSchema refresh() {
        this.innerObject = this.serviceManager.serviceClient().getMetadataSchemas().getWithResponse(this.resourceGroupName, this.serviceName, this.metadataSchemaName, Context.NONE).getValue();
        return this;
    }

    @Override
    public MetadataSchema refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getMetadataSchemas().getWithResponse(this.resourceGroupName, this.serviceName, this.metadataSchemaName, context).getValue();
        return this;
    }

    @Override
    public MetadataSchemaImpl withProperties(MetadataSchemaProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

