/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apicenter.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apicenter.ApiCenterManager;
import com.azure.resourcemanager.apicenter.fluent.MetadataSchemasClient;
import com.azure.resourcemanager.apicenter.fluent.models.MetadataSchemaInner;
import com.azure.resourcemanager.apicenter.implementation.MetadataSchemaImpl;
import com.azure.resourcemanager.apicenter.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apicenter.models.MetadataSchema;
import com.azure.resourcemanager.apicenter.models.MetadataSchemas;
import com.azure.resourcemanager.apicenter.models.MetadataSchemasGetResponse;

public final class MetadataSchemasImpl
implements MetadataSchemas {
    private static final ClientLogger LOGGER = new ClientLogger(MetadataSchemasImpl.class);
    private final MetadataSchemasClient innerClient;
    private final ApiCenterManager serviceManager;

    public MetadataSchemasImpl(MetadataSchemasClient innerClient, ApiCenterManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<MetadataSchema> list(String resourceGroupName, String serviceName) {
        PagedIterable<MetadataSchemaInner> inner = this.serviceClient().list(resourceGroupName, serviceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new MetadataSchemaImpl((MetadataSchemaInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<MetadataSchema> list(String resourceGroupName, String serviceName, String filter, Context context) {
        PagedIterable<MetadataSchemaInner> inner = this.serviceClient().list(resourceGroupName, serviceName, filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new MetadataSchemaImpl((MetadataSchemaInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<MetadataSchema> getWithResponse(String resourceGroupName, String serviceName, String metadataSchemaName, Context context) {
        MetadataSchemasGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, metadataSchemaName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new MetadataSchemaImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public MetadataSchema get(String resourceGroupName, String serviceName, String metadataSchemaName) {
        MetadataSchemaInner inner = this.serviceClient().get(resourceGroupName, serviceName, metadataSchemaName);
        if (inner != null) {
            return new MetadataSchemaImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String metadataSchemaName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, metadataSchemaName, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String metadataSchemaName) {
        this.serviceClient().delete(resourceGroupName, serviceName, metadataSchemaName);
    }

    @Override
    public Response<Void> headWithResponse(String resourceGroupName, String serviceName, String metadataSchemaName, Context context) {
        return this.serviceClient().headWithResponse(resourceGroupName, serviceName, metadataSchemaName, context);
    }

    @Override
    public void head(String resourceGroupName, String serviceName, String metadataSchemaName) {
        this.serviceClient().head(resourceGroupName, serviceName, metadataSchemaName);
    }

    @Override
    public MetadataSchema getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "services");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'services'.", id)));
        }
        String metadataSchemaName = ResourceManagerUtils.getValueFromIdByName(id, "metadataSchemas");
        if (metadataSchemaName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'metadataSchemas'.", id)));
        }
        return (MetadataSchema)this.getWithResponse(resourceGroupName, serviceName, metadataSchemaName, Context.NONE).getValue();
    }

    @Override
    public Response<MetadataSchema> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "services");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'services'.", id)));
        }
        String metadataSchemaName = ResourceManagerUtils.getValueFromIdByName(id, "metadataSchemas");
        if (metadataSchemaName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'metadataSchemas'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, metadataSchemaName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "services");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'services'.", id)));
        }
        String metadataSchemaName = ResourceManagerUtils.getValueFromIdByName(id, "metadataSchemas");
        if (metadataSchemaName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'metadataSchemas'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, serviceName, metadataSchemaName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "services");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'services'.", id)));
        }
        String metadataSchemaName = ResourceManagerUtils.getValueFromIdByName(id, "metadataSchemas");
        if (metadataSchemaName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'metadataSchemas'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, metadataSchemaName, context);
    }

    private MetadataSchemasClient serviceClient() {
        return this.innerClient;
    }

    private ApiCenterManager manager() {
        return this.serviceManager;
    }

    @Override
    public MetadataSchemaImpl define(String name) {
        return new MetadataSchemaImpl(name, this.manager());
    }
}

