/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apicenter.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apicenter.ApiCenterManager;
import com.azure.resourcemanager.apicenter.fluent.models.ServiceInner;
import com.azure.resourcemanager.apicenter.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apicenter.models.ManagedServiceIdentity;
import com.azure.resourcemanager.apicenter.models.MetadataSchemaExportRequest;
import com.azure.resourcemanager.apicenter.models.MetadataSchemaExportResult;
import com.azure.resourcemanager.apicenter.models.Service;
import com.azure.resourcemanager.apicenter.models.ServiceProperties;
import com.azure.resourcemanager.apicenter.models.ServiceUpdate;
import java.util.Collections;
import java.util.Map;

public final class ServiceImpl
implements Service,
Service.Definition,
Service.Update {
    private ServiceInner innerObject;
    private final ApiCenterManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private ServiceUpdate updateProperties;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public ServiceProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public ManagedServiceIdentity identity() {
        return this.innerModel().identity();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ServiceInner innerModel() {
        return this.innerObject;
    }

    private ApiCenterManager manager() {
        return this.serviceManager;
    }

    @Override
    public ServiceImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public Service create() {
        this.innerObject = (ServiceInner)((Object)this.serviceManager.serviceClient().getServices().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public Service create(Context context) {
        this.innerObject = (ServiceInner)((Object)this.serviceManager.serviceClient().getServices().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.innerModel(), context).getValue());
        return this;
    }

    ServiceImpl(String name, ApiCenterManager serviceManager) {
        this.innerObject = new ServiceInner();
        this.serviceManager = serviceManager;
        this.serviceName = name;
    }

    @Override
    public ServiceImpl update() {
        this.updateProperties = new ServiceUpdate();
        return this;
    }

    @Override
    public Service apply() {
        this.innerObject = (ServiceInner)((Object)this.serviceManager.serviceClient().getServices().updateWithResponse(this.resourceGroupName, this.serviceName, this.updateProperties, Context.NONE).getValue());
        return this;
    }

    @Override
    public Service apply(Context context) {
        this.innerObject = (ServiceInner)((Object)this.serviceManager.serviceClient().getServices().updateWithResponse(this.resourceGroupName, this.serviceName, this.updateProperties, context).getValue());
        return this;
    }

    ServiceImpl(ServiceInner innerObject, ApiCenterManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "services");
    }

    @Override
    public Service refresh() {
        this.innerObject = (ServiceInner)((Object)this.serviceManager.serviceClient().getServices().getByResourceGroupWithResponse(this.resourceGroupName, this.serviceName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Service refresh(Context context) {
        this.innerObject = (ServiceInner)((Object)this.serviceManager.serviceClient().getServices().getByResourceGroupWithResponse(this.resourceGroupName, this.serviceName, context).getValue());
        return this;
    }

    @Override
    public MetadataSchemaExportResult exportMetadataSchema(MetadataSchemaExportRequest body) {
        return this.serviceManager.services().exportMetadataSchema(this.resourceGroupName, this.serviceName, body);
    }

    @Override
    public MetadataSchemaExportResult exportMetadataSchema(MetadataSchemaExportRequest body, Context context) {
        return this.serviceManager.services().exportMetadataSchema(this.resourceGroupName, this.serviceName, body, context);
    }

    @Override
    public ServiceImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public ServiceImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public ServiceImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateProperties.withTags(tags);
        return this;
    }

    @Override
    public ServiceImpl withProperties(ServiceProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public ServiceImpl withIdentity(ManagedServiceIdentity identity) {
        if (this.isInCreateMode()) {
            this.innerModel().withIdentity(identity);
            return this;
        }
        this.updateProperties.withIdentity(identity);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

