/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apicenter.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apicenter.ApiCenterManager;
import com.azure.resourcemanager.apicenter.fluent.ServicesClient;
import com.azure.resourcemanager.apicenter.fluent.models.MetadataSchemaExportResultInner;
import com.azure.resourcemanager.apicenter.fluent.models.ServiceInner;
import com.azure.resourcemanager.apicenter.implementation.MetadataSchemaExportResultImpl;
import com.azure.resourcemanager.apicenter.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apicenter.implementation.ServiceImpl;
import com.azure.resourcemanager.apicenter.models.MetadataSchemaExportRequest;
import com.azure.resourcemanager.apicenter.models.MetadataSchemaExportResult;
import com.azure.resourcemanager.apicenter.models.Service;
import com.azure.resourcemanager.apicenter.models.Services;

public final class ServicesImpl
implements Services {
    private static final ClientLogger LOGGER = new ClientLogger(ServicesImpl.class);
    private final ServicesClient innerClient;
    private final ApiCenterManager serviceManager;

    public ServicesImpl(ServicesClient innerClient, ApiCenterManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Service> list() {
        PagedIterable<ServiceInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ServiceImpl((ServiceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Service> list(Context context) {
        PagedIterable<ServiceInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ServiceImpl((ServiceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Service> listByResourceGroup(String resourceGroupName) {
        PagedIterable<ServiceInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ServiceImpl((ServiceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Service> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<ServiceInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ServiceImpl((ServiceInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<Service> getByResourceGroupWithResponse(String resourceGroupName, String serviceName, Context context) {
        Response<ServiceInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, serviceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ServiceImpl((ServiceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Service getByResourceGroup(String resourceGroupName, String serviceName) {
        ServiceInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, serviceName);
        if (inner != null) {
            return new ServiceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteByResourceGroupWithResponse(String resourceGroupName, String serviceName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, context);
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String serviceName) {
        this.serviceClient().delete(resourceGroupName, serviceName);
    }

    @Override
    public MetadataSchemaExportResult exportMetadataSchema(String resourceGroupName, String serviceName, MetadataSchemaExportRequest body) {
        MetadataSchemaExportResultInner inner = this.serviceClient().exportMetadataSchema(resourceGroupName, serviceName, body);
        if (inner != null) {
            return new MetadataSchemaExportResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public MetadataSchemaExportResult exportMetadataSchema(String resourceGroupName, String serviceName, MetadataSchemaExportRequest body, Context context) {
        MetadataSchemaExportResultInner inner = this.serviceClient().exportMetadataSchema(resourceGroupName, serviceName, body, context);
        if (inner != null) {
            return new MetadataSchemaExportResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Service getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "services");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'services'.", id)));
        }
        return (Service)this.getByResourceGroupWithResponse(resourceGroupName, serviceName, Context.NONE).getValue();
    }

    @Override
    public Response<Service> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "services");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'services'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, serviceName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "services");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'services'.", id)));
        }
        this.deleteByResourceGroupWithResponse(resourceGroupName, serviceName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "services");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'services'.", id)));
        }
        return this.deleteByResourceGroupWithResponse(resourceGroupName, serviceName, context);
    }

    private ServicesClient serviceClient() {
        return this.innerClient;
    }

    private ApiCenterManager manager() {
        return this.serviceManager;
    }

    @Override
    public ServiceImpl define(String name) {
        return new ServiceImpl(name, this.manager());
    }
}

