/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apicenter.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apicenter.ApiCenterManager;
import com.azure.resourcemanager.apicenter.fluent.models.WorkspaceInner;
import com.azure.resourcemanager.apicenter.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apicenter.models.Workspace;
import com.azure.resourcemanager.apicenter.models.WorkspaceProperties;

public final class WorkspaceImpl
implements Workspace,
Workspace.Definition,
Workspace.Update {
    private WorkspaceInner innerObject;
    private final ApiCenterManager serviceManager;
    private String resourceGroupName;
    private String serviceName;
    private String workspaceName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public WorkspaceProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public WorkspaceInner innerModel() {
        return this.innerObject;
    }

    private ApiCenterManager manager() {
        return this.serviceManager;
    }

    @Override
    public WorkspaceImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    @Override
    public Workspace create() {
        this.innerObject = this.serviceManager.serviceClient().getWorkspaces().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.workspaceName, this.innerModel(), Context.NONE).getValue();
        return this;
    }

    @Override
    public Workspace create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getWorkspaces().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.workspaceName, this.innerModel(), context).getValue();
        return this;
    }

    WorkspaceImpl(String name, ApiCenterManager serviceManager) {
        this.innerObject = new WorkspaceInner();
        this.serviceManager = serviceManager;
        this.workspaceName = name;
    }

    @Override
    public WorkspaceImpl update() {
        return this;
    }

    @Override
    public Workspace apply() {
        this.innerObject = this.serviceManager.serviceClient().getWorkspaces().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.workspaceName, this.innerModel(), Context.NONE).getValue();
        return this;
    }

    @Override
    public Workspace apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getWorkspaces().createOrUpdateWithResponse(this.resourceGroupName, this.serviceName, this.workspaceName, this.innerModel(), context).getValue();
        return this;
    }

    WorkspaceImpl(WorkspaceInner innerObject, ApiCenterManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "services");
        this.workspaceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "workspaces");
    }

    @Override
    public Workspace refresh() {
        this.innerObject = this.serviceManager.serviceClient().getWorkspaces().getWithResponse(this.resourceGroupName, this.serviceName, this.workspaceName, Context.NONE).getValue();
        return this;
    }

    @Override
    public Workspace refresh(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getWorkspaces().getWithResponse(this.resourceGroupName, this.serviceName, this.workspaceName, context).getValue();
        return this;
    }

    @Override
    public WorkspaceImpl withProperties(WorkspaceProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

