/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apicenter.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apicenter.ApiCenterManager;
import com.azure.resourcemanager.apicenter.fluent.WorkspacesClient;
import com.azure.resourcemanager.apicenter.fluent.models.WorkspaceInner;
import com.azure.resourcemanager.apicenter.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.apicenter.implementation.WorkspaceImpl;
import com.azure.resourcemanager.apicenter.models.Workspace;
import com.azure.resourcemanager.apicenter.models.Workspaces;
import com.azure.resourcemanager.apicenter.models.WorkspacesGetResponse;

public final class WorkspacesImpl
implements Workspaces {
    private static final ClientLogger LOGGER = new ClientLogger(WorkspacesImpl.class);
    private final WorkspacesClient innerClient;
    private final ApiCenterManager serviceManager;

    public WorkspacesImpl(WorkspacesClient innerClient, ApiCenterManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Workspace> list(String resourceGroupName, String serviceName) {
        PagedIterable<WorkspaceInner> inner = this.serviceClient().list(resourceGroupName, serviceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new WorkspaceImpl((WorkspaceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Workspace> list(String resourceGroupName, String serviceName, String filter, Context context) {
        PagedIterable<WorkspaceInner> inner = this.serviceClient().list(resourceGroupName, serviceName, filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new WorkspaceImpl((WorkspaceInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<Workspace> getWithResponse(String resourceGroupName, String serviceName, String workspaceName, Context context) {
        WorkspacesGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, serviceName, workspaceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new WorkspaceImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public Workspace get(String resourceGroupName, String serviceName, String workspaceName) {
        WorkspaceInner inner = this.serviceClient().get(resourceGroupName, serviceName, workspaceName);
        if (inner != null) {
            return new WorkspaceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String workspaceName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, workspaceName, context);
    }

    @Override
    public void delete(String resourceGroupName, String serviceName, String workspaceName) {
        this.serviceClient().delete(resourceGroupName, serviceName, workspaceName);
    }

    @Override
    public Response<Void> headWithResponse(String resourceGroupName, String serviceName, String workspaceName, Context context) {
        return this.serviceClient().headWithResponse(resourceGroupName, serviceName, workspaceName, context);
    }

    @Override
    public void head(String resourceGroupName, String serviceName, String workspaceName) {
        this.serviceClient().head(resourceGroupName, serviceName, workspaceName);
    }

    @Override
    public Workspace getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "services");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'services'.", id)));
        }
        String workspaceName = ResourceManagerUtils.getValueFromIdByName(id, "workspaces");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        return (Workspace)this.getWithResponse(resourceGroupName, serviceName, workspaceName, Context.NONE).getValue();
    }

    @Override
    public Response<Workspace> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "services");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'services'.", id)));
        }
        String workspaceName = ResourceManagerUtils.getValueFromIdByName(id, "workspaces");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, workspaceName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "services");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'services'.", id)));
        }
        String workspaceName = ResourceManagerUtils.getValueFromIdByName(id, "workspaces");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, serviceName, workspaceName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "services");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'services'.", id)));
        }
        String workspaceName = ResourceManagerUtils.getValueFromIdByName(id, "workspaces");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, workspaceName, context);
    }

    private WorkspacesClient serviceClient() {
        return this.innerClient;
    }

    private ApiCenterManager manager() {
        return this.serviceManager;
    }

    @Override
    public WorkspaceImpl define(String name) {
        return new WorkspaceImpl(name, this.manager());
    }
}

