/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apicenter.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apicenter.models.ApiKind;
import com.azure.resourcemanager.apicenter.models.Contact;
import com.azure.resourcemanager.apicenter.models.ExternalDocumentation;
import com.azure.resourcemanager.apicenter.models.License;
import com.azure.resourcemanager.apicenter.models.LifecycleStage;
import com.azure.resourcemanager.apicenter.models.TermsOfService;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class ApiProperties {
    @JsonProperty(value="title", required=true)
    private String title;
    @JsonProperty(value="kind", required=true)
    private ApiKind kind;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="summary")
    private String summary;
    @JsonProperty(value="lifecycleStage", access=JsonProperty.Access.WRITE_ONLY)
    private LifecycleStage lifecycleStage;
    @JsonProperty(value="termsOfService")
    private TermsOfService termsOfService;
    @JsonProperty(value="externalDocumentation")
    private List<ExternalDocumentation> externalDocumentation;
    @JsonProperty(value="contacts")
    private List<Contact> contacts;
    @JsonProperty(value="license")
    private License license;
    @JsonProperty(value="customProperties")
    private Object customProperties;
    private static final ClientLogger LOGGER = new ClientLogger(ApiProperties.class);

    public String title() {
        return this.title;
    }

    public ApiProperties withTitle(String title) {
        this.title = title;
        return this;
    }

    public ApiKind kind() {
        return this.kind;
    }

    public ApiProperties withKind(ApiKind kind) {
        this.kind = kind;
        return this;
    }

    public String description() {
        return this.description;
    }

    public ApiProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public String summary() {
        return this.summary;
    }

    public ApiProperties withSummary(String summary) {
        this.summary = summary;
        return this;
    }

    public LifecycleStage lifecycleStage() {
        return this.lifecycleStage;
    }

    public TermsOfService termsOfService() {
        return this.termsOfService;
    }

    public ApiProperties withTermsOfService(TermsOfService termsOfService) {
        this.termsOfService = termsOfService;
        return this;
    }

    public List<ExternalDocumentation> externalDocumentation() {
        return this.externalDocumentation;
    }

    public ApiProperties withExternalDocumentation(List<ExternalDocumentation> externalDocumentation) {
        this.externalDocumentation = externalDocumentation;
        return this;
    }

    public List<Contact> contacts() {
        return this.contacts;
    }

    public ApiProperties withContacts(List<Contact> contacts) {
        this.contacts = contacts;
        return this;
    }

    public License license() {
        return this.license;
    }

    public ApiProperties withLicense(License license) {
        this.license = license;
        return this;
    }

    public Object customProperties() {
        return this.customProperties;
    }

    public ApiProperties withCustomProperties(Object customProperties) {
        this.customProperties = customProperties;
        return this;
    }

    public void validate() {
        if (this.title() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property title in model ApiProperties"));
        }
        if (this.kind() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property kind in model ApiProperties"));
        }
        if (this.termsOfService() != null) {
            this.termsOfService().validate();
        }
        if (this.externalDocumentation() != null) {
            this.externalDocumentation().forEach(e -> e.validate());
        }
        if (this.contacts() != null) {
            this.contacts().forEach(e -> e.validate());
        }
        if (this.license() != null) {
            this.license().validate();
        }
    }
}

