/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apicenter.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apicenter.models.EnvironmentKind;
import com.azure.resourcemanager.apicenter.models.EnvironmentServer;
import com.azure.resourcemanager.apicenter.models.Onboarding;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class EnvironmentProperties {
    @JsonProperty(value="title", required=true)
    private String title;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="kind", required=true)
    private EnvironmentKind kind;
    @JsonProperty(value="server")
    private EnvironmentServer server;
    @JsonProperty(value="onboarding")
    private Onboarding onboarding;
    @JsonProperty(value="customProperties")
    private Object customProperties;
    private static final ClientLogger LOGGER = new ClientLogger(EnvironmentProperties.class);

    public String title() {
        return this.title;
    }

    public EnvironmentProperties withTitle(String title) {
        this.title = title;
        return this;
    }

    public String description() {
        return this.description;
    }

    public EnvironmentProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public EnvironmentKind kind() {
        return this.kind;
    }

    public EnvironmentProperties withKind(EnvironmentKind kind) {
        this.kind = kind;
        return this;
    }

    public EnvironmentServer server() {
        return this.server;
    }

    public EnvironmentProperties withServer(EnvironmentServer server) {
        this.server = server;
        return this;
    }

    public Onboarding onboarding() {
        return this.onboarding;
    }

    public EnvironmentProperties withOnboarding(Onboarding onboarding) {
        this.onboarding = onboarding;
        return this;
    }

    public Object customProperties() {
        return this.customProperties;
    }

    public EnvironmentProperties withCustomProperties(Object customProperties) {
        this.customProperties = customProperties;
        return this;
    }

    public void validate() {
        if (this.title() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property title in model EnvironmentProperties"));
        }
        if (this.kind() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property kind in model EnvironmentProperties"));
        }
        if (this.server() != null) {
            this.server().validate();
        }
        if (this.onboarding() != null) {
            this.onboarding().validate();
        }
    }
}

