/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apicenter.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apicenter.fluent.models.ServiceInner;
import com.azure.resourcemanager.apicenter.models.ManagedServiceIdentity;
import com.azure.resourcemanager.apicenter.models.MetadataSchemaExportRequest;
import com.azure.resourcemanager.apicenter.models.MetadataSchemaExportResult;
import com.azure.resourcemanager.apicenter.models.ServiceProperties;
import java.util.Map;

public interface Service {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public ServiceProperties properties();

    public ManagedServiceIdentity identity();

    public SystemData systemData();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public ServiceInner innerModel();

    public Update update();

    public Service refresh();

    public Service refresh(Context var1);

    public MetadataSchemaExportResult exportMetadataSchema(MetadataSchemaExportRequest var1);

    public MetadataSchemaExportResult exportMetadataSchema(MetadataSchemaExportRequest var1, Context var2);

    public static interface UpdateStages {

        public static interface WithIdentity {
            public Update withIdentity(ManagedServiceIdentity var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithIdentity {
        public Service apply();

        public Service apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithIdentity {
            public WithCreate withIdentity(ManagedServiceIdentity var1);
        }

        public static interface WithProperties {
            public WithCreate withProperties(ServiceProperties var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithProperties,
        WithIdentity {
            public Service create();

            public Service create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

