/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.AdditionalLocation;
import com.azure.resourcemanager.apimanagement.models.ApiManagementServiceBaseProperties;
import com.azure.resourcemanager.apimanagement.models.ApiVersionConstraint;
import com.azure.resourcemanager.apimanagement.models.CertificateConfiguration;
import com.azure.resourcemanager.apimanagement.models.HostnameConfiguration;
import com.azure.resourcemanager.apimanagement.models.NatGatewayState;
import com.azure.resourcemanager.apimanagement.models.PlatformVersion;
import com.azure.resourcemanager.apimanagement.models.PublicNetworkAccess;
import com.azure.resourcemanager.apimanagement.models.RemotePrivateEndpointConnectionWrapper;
import com.azure.resourcemanager.apimanagement.models.VirtualNetworkConfiguration;
import com.azure.resourcemanager.apimanagement.models.VirtualNetworkType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class ApiManagementServiceProperties
extends ApiManagementServiceBaseProperties {
    private String publisherEmail;
    private String publisherName;
    private PlatformVersion platformVersion;
    private List<String> outboundPublicIpAddresses;
    private List<String> privateIpAddresses;
    private List<String> publicIpAddresses;
    private String developerPortalUrl;
    private String scmUrl;
    private String managementApiUrl;
    private String portalUrl;
    private String gatewayRegionalUrl;
    private String gatewayUrl;
    private OffsetDateTime createdAtUtc;
    private String targetProvisioningState;
    private String provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(ApiManagementServiceProperties.class);

    public String publisherEmail() {
        return this.publisherEmail;
    }

    public ApiManagementServiceProperties withPublisherEmail(String publisherEmail) {
        this.publisherEmail = publisherEmail;
        return this;
    }

    public String publisherName() {
        return this.publisherName;
    }

    public ApiManagementServiceProperties withPublisherName(String publisherName) {
        this.publisherName = publisherName;
        return this;
    }

    @Override
    public PlatformVersion platformVersion() {
        return this.platformVersion;
    }

    @Override
    public List<String> outboundPublicIpAddresses() {
        return this.outboundPublicIpAddresses;
    }

    @Override
    public List<String> privateIpAddresses() {
        return this.privateIpAddresses;
    }

    @Override
    public List<String> publicIpAddresses() {
        return this.publicIpAddresses;
    }

    @Override
    public String developerPortalUrl() {
        return this.developerPortalUrl;
    }

    @Override
    public String scmUrl() {
        return this.scmUrl;
    }

    @Override
    public String managementApiUrl() {
        return this.managementApiUrl;
    }

    @Override
    public String portalUrl() {
        return this.portalUrl;
    }

    @Override
    public String gatewayRegionalUrl() {
        return this.gatewayRegionalUrl;
    }

    @Override
    public String gatewayUrl() {
        return this.gatewayUrl;
    }

    @Override
    public OffsetDateTime createdAtUtc() {
        return this.createdAtUtc;
    }

    @Override
    public String targetProvisioningState() {
        return this.targetProvisioningState;
    }

    @Override
    public String provisioningState() {
        return this.provisioningState;
    }

    @Override
    public ApiManagementServiceProperties withNotificationSenderEmail(String notificationSenderEmail) {
        super.withNotificationSenderEmail(notificationSenderEmail);
        return this;
    }

    @Override
    public ApiManagementServiceProperties withHostnameConfigurations(List<HostnameConfiguration> hostnameConfigurations) {
        super.withHostnameConfigurations(hostnameConfigurations);
        return this;
    }

    @Override
    public ApiManagementServiceProperties withPublicIpAddressId(String publicIpAddressId) {
        super.withPublicIpAddressId(publicIpAddressId);
        return this;
    }

    @Override
    public ApiManagementServiceProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        super.withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    @Override
    public ApiManagementServiceProperties withVirtualNetworkConfiguration(VirtualNetworkConfiguration virtualNetworkConfiguration) {
        super.withVirtualNetworkConfiguration(virtualNetworkConfiguration);
        return this;
    }

    @Override
    public ApiManagementServiceProperties withAdditionalLocations(List<AdditionalLocation> additionalLocations) {
        super.withAdditionalLocations(additionalLocations);
        return this;
    }

    @Override
    public ApiManagementServiceProperties withCustomProperties(Map<String, String> customProperties) {
        super.withCustomProperties(customProperties);
        return this;
    }

    @Override
    public ApiManagementServiceProperties withCertificates(List<CertificateConfiguration> certificates) {
        super.withCertificates(certificates);
        return this;
    }

    @Override
    public ApiManagementServiceProperties withEnableClientCertificate(Boolean enableClientCertificate) {
        super.withEnableClientCertificate(enableClientCertificate);
        return this;
    }

    @Override
    public ApiManagementServiceProperties withNatGatewayState(NatGatewayState natGatewayState) {
        super.withNatGatewayState(natGatewayState);
        return this;
    }

    @Override
    public ApiManagementServiceProperties withDisableGateway(Boolean disableGateway) {
        super.withDisableGateway(disableGateway);
        return this;
    }

    @Override
    public ApiManagementServiceProperties withVirtualNetworkType(VirtualNetworkType virtualNetworkType) {
        super.withVirtualNetworkType(virtualNetworkType);
        return this;
    }

    @Override
    public ApiManagementServiceProperties withApiVersionConstraint(ApiVersionConstraint apiVersionConstraint) {
        super.withApiVersionConstraint(apiVersionConstraint);
        return this;
    }

    @Override
    public ApiManagementServiceProperties withRestore(Boolean restore) {
        super.withRestore(restore);
        return this;
    }

    @Override
    public ApiManagementServiceProperties withPrivateEndpointConnections(List<RemotePrivateEndpointConnectionWrapper> privateEndpointConnections) {
        super.withPrivateEndpointConnections(privateEndpointConnections);
        return this;
    }

    @Override
    public void validate() {
        if (this.publisherEmail() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property publisherEmail in model ApiManagementServiceProperties"));
        }
        if (this.publisherName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property publisherName in model ApiManagementServiceProperties"));
        }
        if (this.hostnameConfigurations() != null) {
            this.hostnameConfigurations().forEach(e -> e.validate());
        }
        if (this.virtualNetworkConfiguration() != null) {
            this.virtualNetworkConfiguration().validate();
        }
        if (this.additionalLocations() != null) {
            this.additionalLocations().forEach(e -> e.validate());
        }
        if (this.certificates() != null) {
            this.certificates().forEach(e -> e.validate());
        }
        if (this.apiVersionConstraint() != null) {
            this.apiVersionConstraint().validate();
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("notificationSenderEmail", this.notificationSenderEmail());
        jsonWriter.writeArrayField("hostnameConfigurations", this.hostnameConfigurations(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("publicIpAddressId", this.publicIpAddressId());
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess() == null ? null : this.publicNetworkAccess().toString());
        jsonWriter.writeJsonField("virtualNetworkConfiguration", (JsonSerializable)this.virtualNetworkConfiguration());
        jsonWriter.writeArrayField("additionalLocations", this.additionalLocations(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeMapField("customProperties", this.customProperties(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("certificates", this.certificates(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("enableClientCertificate", this.enableClientCertificate());
        jsonWriter.writeStringField("natGatewayState", this.natGatewayState() == null ? null : this.natGatewayState().toString());
        jsonWriter.writeBooleanField("disableGateway", this.disableGateway());
        jsonWriter.writeStringField("virtualNetworkType", this.virtualNetworkType() == null ? null : this.virtualNetworkType().toString());
        jsonWriter.writeJsonField("apiVersionConstraint", (JsonSerializable)this.apiVersionConstraint());
        jsonWriter.writeBooleanField("restore", this.restore());
        jsonWriter.writeArrayField("privateEndpointConnections", this.privateEndpointConnections(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("publisherEmail", this.publisherEmail);
        jsonWriter.writeStringField("publisherName", this.publisherName);
        return jsonWriter.writeEndObject();
    }

    public static ApiManagementServiceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ApiManagementServiceProperties)jsonReader.readObject(reader -> {
            ApiManagementServiceProperties deserializedApiManagementServiceProperties = new ApiManagementServiceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("notificationSenderEmail".equals(fieldName)) {
                    deserializedApiManagementServiceProperties.withNotificationSenderEmail(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedApiManagementServiceProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("targetProvisioningState".equals(fieldName)) {
                    deserializedApiManagementServiceProperties.targetProvisioningState = reader.getString();
                    continue;
                }
                if ("createdAtUtc".equals(fieldName)) {
                    deserializedApiManagementServiceProperties.createdAtUtc = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("gatewayUrl".equals(fieldName)) {
                    deserializedApiManagementServiceProperties.gatewayUrl = reader.getString();
                    continue;
                }
                if ("gatewayRegionalUrl".equals(fieldName)) {
                    deserializedApiManagementServiceProperties.gatewayRegionalUrl = reader.getString();
                    continue;
                }
                if ("portalUrl".equals(fieldName)) {
                    deserializedApiManagementServiceProperties.portalUrl = reader.getString();
                    continue;
                }
                if ("managementApiUrl".equals(fieldName)) {
                    deserializedApiManagementServiceProperties.managementApiUrl = reader.getString();
                    continue;
                }
                if ("scmUrl".equals(fieldName)) {
                    deserializedApiManagementServiceProperties.scmUrl = reader.getString();
                    continue;
                }
                if ("developerPortalUrl".equals(fieldName)) {
                    deserializedApiManagementServiceProperties.developerPortalUrl = reader.getString();
                    continue;
                }
                if ("hostnameConfigurations".equals(fieldName)) {
                    List hostnameConfigurations = reader.readArray(reader1 -> HostnameConfiguration.fromJson(reader1));
                    deserializedApiManagementServiceProperties.withHostnameConfigurations(hostnameConfigurations);
                    continue;
                }
                if ("publicIPAddresses".equals(fieldName)) {
                    List publicIpAddresses;
                    deserializedApiManagementServiceProperties.publicIpAddresses = publicIpAddresses = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("privateIPAddresses".equals(fieldName)) {
                    List privateIpAddresses;
                    deserializedApiManagementServiceProperties.privateIpAddresses = privateIpAddresses = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("publicIpAddressId".equals(fieldName)) {
                    deserializedApiManagementServiceProperties.withPublicIpAddressId(reader.getString());
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedApiManagementServiceProperties.withPublicNetworkAccess(PublicNetworkAccess.fromString(reader.getString()));
                    continue;
                }
                if ("virtualNetworkConfiguration".equals(fieldName)) {
                    deserializedApiManagementServiceProperties.withVirtualNetworkConfiguration(VirtualNetworkConfiguration.fromJson(reader));
                    continue;
                }
                if ("additionalLocations".equals(fieldName)) {
                    List additionalLocations = reader.readArray(reader1 -> AdditionalLocation.fromJson(reader1));
                    deserializedApiManagementServiceProperties.withAdditionalLocations(additionalLocations);
                    continue;
                }
                if ("customProperties".equals(fieldName)) {
                    Map customProperties = reader.readMap(reader1 -> reader1.getString());
                    deserializedApiManagementServiceProperties.withCustomProperties(customProperties);
                    continue;
                }
                if ("certificates".equals(fieldName)) {
                    List certificates = reader.readArray(reader1 -> CertificateConfiguration.fromJson(reader1));
                    deserializedApiManagementServiceProperties.withCertificates(certificates);
                    continue;
                }
                if ("enableClientCertificate".equals(fieldName)) {
                    deserializedApiManagementServiceProperties.withEnableClientCertificate((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("natGatewayState".equals(fieldName)) {
                    deserializedApiManagementServiceProperties.withNatGatewayState(NatGatewayState.fromString(reader.getString()));
                    continue;
                }
                if ("outboundPublicIPAddresses".equals(fieldName)) {
                    List outboundPublicIpAddresses;
                    deserializedApiManagementServiceProperties.outboundPublicIpAddresses = outboundPublicIpAddresses = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("disableGateway".equals(fieldName)) {
                    deserializedApiManagementServiceProperties.withDisableGateway((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("virtualNetworkType".equals(fieldName)) {
                    deserializedApiManagementServiceProperties.withVirtualNetworkType(VirtualNetworkType.fromString(reader.getString()));
                    continue;
                }
                if ("apiVersionConstraint".equals(fieldName)) {
                    deserializedApiManagementServiceProperties.withApiVersionConstraint(ApiVersionConstraint.fromJson(reader));
                    continue;
                }
                if ("restore".equals(fieldName)) {
                    deserializedApiManagementServiceProperties.withRestore((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("privateEndpointConnections".equals(fieldName)) {
                    List privateEndpointConnections = reader.readArray(reader1 -> RemotePrivateEndpointConnectionWrapper.fromJson(reader1));
                    deserializedApiManagementServiceProperties.withPrivateEndpointConnections(privateEndpointConnections);
                    continue;
                }
                if ("platformVersion".equals(fieldName)) {
                    deserializedApiManagementServiceProperties.platformVersion = PlatformVersion.fromString(reader.getString());
                    continue;
                }
                if ("publisherEmail".equals(fieldName)) {
                    deserializedApiManagementServiceProperties.publisherEmail = reader.getString();
                    continue;
                }
                if ("publisherName".equals(fieldName)) {
                    deserializedApiManagementServiceProperties.publisherName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApiManagementServiceProperties;
        });
    }
}

