/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiManagementServiceProperties;
import com.azure.resourcemanager.apimanagement.models.AdditionalLocation;
import com.azure.resourcemanager.apimanagement.models.ApiManagementServiceIdentity;
import com.azure.resourcemanager.apimanagement.models.ApiManagementServiceSkuProperties;
import com.azure.resourcemanager.apimanagement.models.ApiVersionConstraint;
import com.azure.resourcemanager.apimanagement.models.ApimResource;
import com.azure.resourcemanager.apimanagement.models.CertificateConfiguration;
import com.azure.resourcemanager.apimanagement.models.HostnameConfiguration;
import com.azure.resourcemanager.apimanagement.models.NatGatewayState;
import com.azure.resourcemanager.apimanagement.models.PlatformVersion;
import com.azure.resourcemanager.apimanagement.models.PublicNetworkAccess;
import com.azure.resourcemanager.apimanagement.models.RemotePrivateEndpointConnectionWrapper;
import com.azure.resourcemanager.apimanagement.models.VirtualNetworkConfiguration;
import com.azure.resourcemanager.apimanagement.models.VirtualNetworkType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class ApiManagementServiceResourceInner
extends ApimResource {
    private ApiManagementServiceProperties innerProperties = new ApiManagementServiceProperties();
    private ApiManagementServiceSkuProperties sku;
    private ApiManagementServiceIdentity identity;
    private SystemData systemData;
    private String location;
    private String etag;
    private List<String> zones;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(ApiManagementServiceResourceInner.class);

    private ApiManagementServiceProperties innerProperties() {
        return this.innerProperties;
    }

    public ApiManagementServiceSkuProperties sku() {
        return this.sku;
    }

    public ApiManagementServiceResourceInner withSku(ApiManagementServiceSkuProperties sku) {
        this.sku = sku;
        return this;
    }

    public ApiManagementServiceIdentity identity() {
        return this.identity;
    }

    public ApiManagementServiceResourceInner withIdentity(ApiManagementServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String location() {
        return this.location;
    }

    public ApiManagementServiceResourceInner withLocation(String location) {
        this.location = location;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public List<String> zones() {
        return this.zones;
    }

    public ApiManagementServiceResourceInner withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public ApiManagementServiceResourceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String publisherEmail() {
        return this.innerProperties() == null ? null : this.innerProperties().publisherEmail();
    }

    public ApiManagementServiceResourceInner withPublisherEmail(String publisherEmail) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceProperties();
        }
        this.innerProperties().withPublisherEmail(publisherEmail);
        return this;
    }

    public String publisherName() {
        return this.innerProperties() == null ? null : this.innerProperties().publisherName();
    }

    public ApiManagementServiceResourceInner withPublisherName(String publisherName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceProperties();
        }
        this.innerProperties().withPublisherName(publisherName);
        return this;
    }

    public String notificationSenderEmail() {
        return this.innerProperties() == null ? null : this.innerProperties().notificationSenderEmail();
    }

    public ApiManagementServiceResourceInner withNotificationSenderEmail(String notificationSenderEmail) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceProperties();
        }
        this.innerProperties().withNotificationSenderEmail(notificationSenderEmail);
        return this;
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String targetProvisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().targetProvisioningState();
    }

    public OffsetDateTime createdAtUtc() {
        return this.innerProperties() == null ? null : this.innerProperties().createdAtUtc();
    }

    public String gatewayUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().gatewayUrl();
    }

    public String gatewayRegionalUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().gatewayRegionalUrl();
    }

    public String portalUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().portalUrl();
    }

    public String managementApiUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().managementApiUrl();
    }

    public String scmUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().scmUrl();
    }

    public String developerPortalUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().developerPortalUrl();
    }

    public List<HostnameConfiguration> hostnameConfigurations() {
        return this.innerProperties() == null ? null : this.innerProperties().hostnameConfigurations();
    }

    public ApiManagementServiceResourceInner withHostnameConfigurations(List<HostnameConfiguration> hostnameConfigurations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceProperties();
        }
        this.innerProperties().withHostnameConfigurations((List)hostnameConfigurations);
        return this;
    }

    public List<String> publicIpAddresses() {
        return this.innerProperties() == null ? null : this.innerProperties().publicIpAddresses();
    }

    public List<String> privateIpAddresses() {
        return this.innerProperties() == null ? null : this.innerProperties().privateIpAddresses();
    }

    public String publicIpAddressId() {
        return this.innerProperties() == null ? null : this.innerProperties().publicIpAddressId();
    }

    public ApiManagementServiceResourceInner withPublicIpAddressId(String publicIpAddressId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceProperties();
        }
        this.innerProperties().withPublicIpAddressId(publicIpAddressId);
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public ApiManagementServiceResourceInner withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public VirtualNetworkConfiguration virtualNetworkConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetworkConfiguration();
    }

    public ApiManagementServiceResourceInner withVirtualNetworkConfiguration(VirtualNetworkConfiguration virtualNetworkConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceProperties();
        }
        this.innerProperties().withVirtualNetworkConfiguration(virtualNetworkConfiguration);
        return this;
    }

    public List<AdditionalLocation> additionalLocations() {
        return this.innerProperties() == null ? null : this.innerProperties().additionalLocations();
    }

    public ApiManagementServiceResourceInner withAdditionalLocations(List<AdditionalLocation> additionalLocations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceProperties();
        }
        this.innerProperties().withAdditionalLocations((List)additionalLocations);
        return this;
    }

    public Map<String, String> customProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().customProperties();
    }

    public ApiManagementServiceResourceInner withCustomProperties(Map<String, String> customProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceProperties();
        }
        this.innerProperties().withCustomProperties((Map)customProperties);
        return this;
    }

    public List<CertificateConfiguration> certificates() {
        return this.innerProperties() == null ? null : this.innerProperties().certificates();
    }

    public ApiManagementServiceResourceInner withCertificates(List<CertificateConfiguration> certificates) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceProperties();
        }
        this.innerProperties().withCertificates((List)certificates);
        return this;
    }

    public Boolean enableClientCertificate() {
        return this.innerProperties() == null ? null : this.innerProperties().enableClientCertificate();
    }

    public ApiManagementServiceResourceInner withEnableClientCertificate(Boolean enableClientCertificate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceProperties();
        }
        this.innerProperties().withEnableClientCertificate(enableClientCertificate);
        return this;
    }

    public NatGatewayState natGatewayState() {
        return this.innerProperties() == null ? null : this.innerProperties().natGatewayState();
    }

    public ApiManagementServiceResourceInner withNatGatewayState(NatGatewayState natGatewayState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceProperties();
        }
        this.innerProperties().withNatGatewayState(natGatewayState);
        return this;
    }

    public List<String> outboundPublicIpAddresses() {
        return this.innerProperties() == null ? null : this.innerProperties().outboundPublicIpAddresses();
    }

    public Boolean disableGateway() {
        return this.innerProperties() == null ? null : this.innerProperties().disableGateway();
    }

    public ApiManagementServiceResourceInner withDisableGateway(Boolean disableGateway) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceProperties();
        }
        this.innerProperties().withDisableGateway(disableGateway);
        return this;
    }

    public VirtualNetworkType virtualNetworkType() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetworkType();
    }

    public ApiManagementServiceResourceInner withVirtualNetworkType(VirtualNetworkType virtualNetworkType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceProperties();
        }
        this.innerProperties().withVirtualNetworkType(virtualNetworkType);
        return this;
    }

    public ApiVersionConstraint apiVersionConstraint() {
        return this.innerProperties() == null ? null : this.innerProperties().apiVersionConstraint();
    }

    public ApiManagementServiceResourceInner withApiVersionConstraint(ApiVersionConstraint apiVersionConstraint) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceProperties();
        }
        this.innerProperties().withApiVersionConstraint(apiVersionConstraint);
        return this;
    }

    public Boolean restore() {
        return this.innerProperties() == null ? null : this.innerProperties().restore();
    }

    public ApiManagementServiceResourceInner withRestore(Boolean restore) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceProperties();
        }
        this.innerProperties().withRestore(restore);
        return this;
    }

    public List<RemotePrivateEndpointConnectionWrapper> privateEndpointConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointConnections();
    }

    public ApiManagementServiceResourceInner withPrivateEndpointConnections(List<RemotePrivateEndpointConnectionWrapper> privateEndpointConnections) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementServiceProperties();
        }
        this.innerProperties().withPrivateEndpointConnections((List)privateEndpointConnections);
        return this;
    }

    public PlatformVersion platformVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().platformVersion();
    }

    @Override
    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model ApiManagementServiceResourceInner"));
        }
        this.innerProperties().validate();
        if (this.sku() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sku in model ApiManagementServiceResourceInner"));
        }
        this.sku().validate();
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.location() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property location in model ApiManagementServiceResourceInner"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeArrayField("zones", this.zones, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ApiManagementServiceResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (ApiManagementServiceResourceInner)((Object)jsonReader.readObject(reader -> {
            ApiManagementServiceResourceInner deserializedApiManagementServiceResourceInner = new ApiManagementServiceResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedApiManagementServiceResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedApiManagementServiceResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedApiManagementServiceResourceInner.type = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedApiManagementServiceResourceInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedApiManagementServiceResourceInner.innerProperties = ApiManagementServiceProperties.fromJson(reader);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedApiManagementServiceResourceInner.sku = ApiManagementServiceSkuProperties.fromJson(reader);
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedApiManagementServiceResourceInner.location = reader.getString();
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedApiManagementServiceResourceInner.identity = ApiManagementServiceIdentity.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedApiManagementServiceResourceInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedApiManagementServiceResourceInner.etag = reader.getString();
                    continue;
                }
                if ("zones".equals(fieldName)) {
                    List zones;
                    deserializedApiManagementServiceResourceInner.zones = zones = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApiManagementServiceResourceInner;
        }));
    }
}

