/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.AdditionalLocation;
import com.azure.resourcemanager.apimanagement.models.ApiManagementServiceBaseProperties;
import com.azure.resourcemanager.apimanagement.models.ApiVersionConstraint;
import com.azure.resourcemanager.apimanagement.models.CertificateConfiguration;
import com.azure.resourcemanager.apimanagement.models.HostnameConfiguration;
import com.azure.resourcemanager.apimanagement.models.NatGatewayState;
import com.azure.resourcemanager.apimanagement.models.PlatformVersion;
import com.azure.resourcemanager.apimanagement.models.PublicNetworkAccess;
import com.azure.resourcemanager.apimanagement.models.RemotePrivateEndpointConnectionWrapper;
import com.azure.resourcemanager.apimanagement.models.VirtualNetworkConfiguration;
import com.azure.resourcemanager.apimanagement.models.VirtualNetworkType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class ApiManagementServiceUpdateProperties
extends ApiManagementServiceBaseProperties {
    private String publisherEmail;
    private String publisherName;
    private PlatformVersion platformVersion;
    private List<String> outboundPublicIpAddresses;
    private List<String> privateIpAddresses;
    private List<String> publicIpAddresses;
    private String developerPortalUrl;
    private String scmUrl;
    private String managementApiUrl;
    private String portalUrl;
    private String gatewayRegionalUrl;
    private String gatewayUrl;
    private OffsetDateTime createdAtUtc;
    private String targetProvisioningState;
    private String provisioningState;

    public String publisherEmail() {
        return this.publisherEmail;
    }

    public ApiManagementServiceUpdateProperties withPublisherEmail(String publisherEmail) {
        this.publisherEmail = publisherEmail;
        return this;
    }

    public String publisherName() {
        return this.publisherName;
    }

    public ApiManagementServiceUpdateProperties withPublisherName(String publisherName) {
        this.publisherName = publisherName;
        return this;
    }

    @Override
    public PlatformVersion platformVersion() {
        return this.platformVersion;
    }

    @Override
    public List<String> outboundPublicIpAddresses() {
        return this.outboundPublicIpAddresses;
    }

    @Override
    public List<String> privateIpAddresses() {
        return this.privateIpAddresses;
    }

    @Override
    public List<String> publicIpAddresses() {
        return this.publicIpAddresses;
    }

    @Override
    public String developerPortalUrl() {
        return this.developerPortalUrl;
    }

    @Override
    public String scmUrl() {
        return this.scmUrl;
    }

    @Override
    public String managementApiUrl() {
        return this.managementApiUrl;
    }

    @Override
    public String portalUrl() {
        return this.portalUrl;
    }

    @Override
    public String gatewayRegionalUrl() {
        return this.gatewayRegionalUrl;
    }

    @Override
    public String gatewayUrl() {
        return this.gatewayUrl;
    }

    @Override
    public OffsetDateTime createdAtUtc() {
        return this.createdAtUtc;
    }

    @Override
    public String targetProvisioningState() {
        return this.targetProvisioningState;
    }

    @Override
    public String provisioningState() {
        return this.provisioningState;
    }

    @Override
    public ApiManagementServiceUpdateProperties withNotificationSenderEmail(String notificationSenderEmail) {
        super.withNotificationSenderEmail(notificationSenderEmail);
        return this;
    }

    @Override
    public ApiManagementServiceUpdateProperties withHostnameConfigurations(List<HostnameConfiguration> hostnameConfigurations) {
        super.withHostnameConfigurations(hostnameConfigurations);
        return this;
    }

    @Override
    public ApiManagementServiceUpdateProperties withPublicIpAddressId(String publicIpAddressId) {
        super.withPublicIpAddressId(publicIpAddressId);
        return this;
    }

    @Override
    public ApiManagementServiceUpdateProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        super.withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    @Override
    public ApiManagementServiceUpdateProperties withVirtualNetworkConfiguration(VirtualNetworkConfiguration virtualNetworkConfiguration) {
        super.withVirtualNetworkConfiguration(virtualNetworkConfiguration);
        return this;
    }

    @Override
    public ApiManagementServiceUpdateProperties withAdditionalLocations(List<AdditionalLocation> additionalLocations) {
        super.withAdditionalLocations(additionalLocations);
        return this;
    }

    @Override
    public ApiManagementServiceUpdateProperties withCustomProperties(Map<String, String> customProperties) {
        super.withCustomProperties(customProperties);
        return this;
    }

    @Override
    public ApiManagementServiceUpdateProperties withCertificates(List<CertificateConfiguration> certificates) {
        super.withCertificates(certificates);
        return this;
    }

    @Override
    public ApiManagementServiceUpdateProperties withEnableClientCertificate(Boolean enableClientCertificate) {
        super.withEnableClientCertificate(enableClientCertificate);
        return this;
    }

    @Override
    public ApiManagementServiceUpdateProperties withNatGatewayState(NatGatewayState natGatewayState) {
        super.withNatGatewayState(natGatewayState);
        return this;
    }

    @Override
    public ApiManagementServiceUpdateProperties withDisableGateway(Boolean disableGateway) {
        super.withDisableGateway(disableGateway);
        return this;
    }

    @Override
    public ApiManagementServiceUpdateProperties withVirtualNetworkType(VirtualNetworkType virtualNetworkType) {
        super.withVirtualNetworkType(virtualNetworkType);
        return this;
    }

    @Override
    public ApiManagementServiceUpdateProperties withApiVersionConstraint(ApiVersionConstraint apiVersionConstraint) {
        super.withApiVersionConstraint(apiVersionConstraint);
        return this;
    }

    @Override
    public ApiManagementServiceUpdateProperties withRestore(Boolean restore) {
        super.withRestore(restore);
        return this;
    }

    @Override
    public ApiManagementServiceUpdateProperties withPrivateEndpointConnections(List<RemotePrivateEndpointConnectionWrapper> privateEndpointConnections) {
        super.withPrivateEndpointConnections(privateEndpointConnections);
        return this;
    }

    @Override
    public void validate() {
        if (this.hostnameConfigurations() != null) {
            this.hostnameConfigurations().forEach(e -> e.validate());
        }
        if (this.virtualNetworkConfiguration() != null) {
            this.virtualNetworkConfiguration().validate();
        }
        if (this.additionalLocations() != null) {
            this.additionalLocations().forEach(e -> e.validate());
        }
        if (this.certificates() != null) {
            this.certificates().forEach(e -> e.validate());
        }
        if (this.apiVersionConstraint() != null) {
            this.apiVersionConstraint().validate();
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("notificationSenderEmail", this.notificationSenderEmail());
        jsonWriter.writeArrayField("hostnameConfigurations", this.hostnameConfigurations(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("publicIpAddressId", this.publicIpAddressId());
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess() == null ? null : this.publicNetworkAccess().toString());
        jsonWriter.writeJsonField("virtualNetworkConfiguration", (JsonSerializable)this.virtualNetworkConfiguration());
        jsonWriter.writeArrayField("additionalLocations", this.additionalLocations(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeMapField("customProperties", this.customProperties(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("certificates", this.certificates(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("enableClientCertificate", this.enableClientCertificate());
        jsonWriter.writeStringField("natGatewayState", this.natGatewayState() == null ? null : this.natGatewayState().toString());
        jsonWriter.writeBooleanField("disableGateway", this.disableGateway());
        jsonWriter.writeStringField("virtualNetworkType", this.virtualNetworkType() == null ? null : this.virtualNetworkType().toString());
        jsonWriter.writeJsonField("apiVersionConstraint", (JsonSerializable)this.apiVersionConstraint());
        jsonWriter.writeBooleanField("restore", this.restore());
        jsonWriter.writeArrayField("privateEndpointConnections", this.privateEndpointConnections(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("publisherEmail", this.publisherEmail);
        jsonWriter.writeStringField("publisherName", this.publisherName);
        return jsonWriter.writeEndObject();
    }

    public static ApiManagementServiceUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ApiManagementServiceUpdateProperties)jsonReader.readObject(reader -> {
            ApiManagementServiceUpdateProperties deserializedApiManagementServiceUpdateProperties = new ApiManagementServiceUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("notificationSenderEmail".equals(fieldName)) {
                    deserializedApiManagementServiceUpdateProperties.withNotificationSenderEmail(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedApiManagementServiceUpdateProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("targetProvisioningState".equals(fieldName)) {
                    deserializedApiManagementServiceUpdateProperties.targetProvisioningState = reader.getString();
                    continue;
                }
                if ("createdAtUtc".equals(fieldName)) {
                    deserializedApiManagementServiceUpdateProperties.createdAtUtc = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("gatewayUrl".equals(fieldName)) {
                    deserializedApiManagementServiceUpdateProperties.gatewayUrl = reader.getString();
                    continue;
                }
                if ("gatewayRegionalUrl".equals(fieldName)) {
                    deserializedApiManagementServiceUpdateProperties.gatewayRegionalUrl = reader.getString();
                    continue;
                }
                if ("portalUrl".equals(fieldName)) {
                    deserializedApiManagementServiceUpdateProperties.portalUrl = reader.getString();
                    continue;
                }
                if ("managementApiUrl".equals(fieldName)) {
                    deserializedApiManagementServiceUpdateProperties.managementApiUrl = reader.getString();
                    continue;
                }
                if ("scmUrl".equals(fieldName)) {
                    deserializedApiManagementServiceUpdateProperties.scmUrl = reader.getString();
                    continue;
                }
                if ("developerPortalUrl".equals(fieldName)) {
                    deserializedApiManagementServiceUpdateProperties.developerPortalUrl = reader.getString();
                    continue;
                }
                if ("hostnameConfigurations".equals(fieldName)) {
                    List hostnameConfigurations = reader.readArray(reader1 -> HostnameConfiguration.fromJson(reader1));
                    deserializedApiManagementServiceUpdateProperties.withHostnameConfigurations(hostnameConfigurations);
                    continue;
                }
                if ("publicIPAddresses".equals(fieldName)) {
                    List publicIpAddresses;
                    deserializedApiManagementServiceUpdateProperties.publicIpAddresses = publicIpAddresses = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("privateIPAddresses".equals(fieldName)) {
                    List privateIpAddresses;
                    deserializedApiManagementServiceUpdateProperties.privateIpAddresses = privateIpAddresses = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("publicIpAddressId".equals(fieldName)) {
                    deserializedApiManagementServiceUpdateProperties.withPublicIpAddressId(reader.getString());
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedApiManagementServiceUpdateProperties.withPublicNetworkAccess(PublicNetworkAccess.fromString(reader.getString()));
                    continue;
                }
                if ("virtualNetworkConfiguration".equals(fieldName)) {
                    deserializedApiManagementServiceUpdateProperties.withVirtualNetworkConfiguration(VirtualNetworkConfiguration.fromJson(reader));
                    continue;
                }
                if ("additionalLocations".equals(fieldName)) {
                    List additionalLocations = reader.readArray(reader1 -> AdditionalLocation.fromJson(reader1));
                    deserializedApiManagementServiceUpdateProperties.withAdditionalLocations(additionalLocations);
                    continue;
                }
                if ("customProperties".equals(fieldName)) {
                    Map customProperties = reader.readMap(reader1 -> reader1.getString());
                    deserializedApiManagementServiceUpdateProperties.withCustomProperties(customProperties);
                    continue;
                }
                if ("certificates".equals(fieldName)) {
                    List certificates = reader.readArray(reader1 -> CertificateConfiguration.fromJson(reader1));
                    deserializedApiManagementServiceUpdateProperties.withCertificates(certificates);
                    continue;
                }
                if ("enableClientCertificate".equals(fieldName)) {
                    deserializedApiManagementServiceUpdateProperties.withEnableClientCertificate((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("natGatewayState".equals(fieldName)) {
                    deserializedApiManagementServiceUpdateProperties.withNatGatewayState(NatGatewayState.fromString(reader.getString()));
                    continue;
                }
                if ("outboundPublicIPAddresses".equals(fieldName)) {
                    List outboundPublicIpAddresses;
                    deserializedApiManagementServiceUpdateProperties.outboundPublicIpAddresses = outboundPublicIpAddresses = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("disableGateway".equals(fieldName)) {
                    deserializedApiManagementServiceUpdateProperties.withDisableGateway((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("virtualNetworkType".equals(fieldName)) {
                    deserializedApiManagementServiceUpdateProperties.withVirtualNetworkType(VirtualNetworkType.fromString(reader.getString()));
                    continue;
                }
                if ("apiVersionConstraint".equals(fieldName)) {
                    deserializedApiManagementServiceUpdateProperties.withApiVersionConstraint(ApiVersionConstraint.fromJson(reader));
                    continue;
                }
                if ("restore".equals(fieldName)) {
                    deserializedApiManagementServiceUpdateProperties.withRestore((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("privateEndpointConnections".equals(fieldName)) {
                    List privateEndpointConnections = reader.readArray(reader1 -> RemotePrivateEndpointConnectionWrapper.fromJson(reader1));
                    deserializedApiManagementServiceUpdateProperties.withPrivateEndpointConnections(privateEndpointConnections);
                    continue;
                }
                if ("platformVersion".equals(fieldName)) {
                    deserializedApiManagementServiceUpdateProperties.platformVersion = PlatformVersion.fromString(reader.getString());
                    continue;
                }
                if ("publisherEmail".equals(fieldName)) {
                    deserializedApiManagementServiceUpdateProperties.publisherEmail = reader.getString();
                    continue;
                }
                if ("publisherName".equals(fieldName)) {
                    deserializedApiManagementServiceUpdateProperties.publisherName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApiManagementServiceUpdateProperties;
        });
    }
}

