/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.ApiManagementSkuCapabilities;
import com.azure.resourcemanager.apimanagement.models.ApiManagementSkuCapacity;
import com.azure.resourcemanager.apimanagement.models.ApiManagementSkuCosts;
import com.azure.resourcemanager.apimanagement.models.ApiManagementSkuLocationInfo;
import com.azure.resourcemanager.apimanagement.models.ApiManagementSkuRestrictions;
import java.io.IOException;
import java.util.List;

public final class ApiManagementSkuInner
implements JsonSerializable<ApiManagementSkuInner> {
    private String resourceType;
    private String name;
    private String tier;
    private String size;
    private String family;
    private String kind;
    private ApiManagementSkuCapacity capacity;
    private List<String> locations;
    private List<ApiManagementSkuLocationInfo> locationInfo;
    private List<String> apiVersions;
    private List<ApiManagementSkuCosts> costs;
    private List<ApiManagementSkuCapabilities> capabilities;
    private List<ApiManagementSkuRestrictions> restrictions;

    public String resourceType() {
        return this.resourceType;
    }

    public String name() {
        return this.name;
    }

    public String tier() {
        return this.tier;
    }

    public String size() {
        return this.size;
    }

    public String family() {
        return this.family;
    }

    public String kind() {
        return this.kind;
    }

    public ApiManagementSkuCapacity capacity() {
        return this.capacity;
    }

    public List<String> locations() {
        return this.locations;
    }

    public List<ApiManagementSkuLocationInfo> locationInfo() {
        return this.locationInfo;
    }

    public List<String> apiVersions() {
        return this.apiVersions;
    }

    public List<ApiManagementSkuCosts> costs() {
        return this.costs;
    }

    public List<ApiManagementSkuCapabilities> capabilities() {
        return this.capabilities;
    }

    public List<ApiManagementSkuRestrictions> restrictions() {
        return this.restrictions;
    }

    public void validate() {
        if (this.capacity() != null) {
            this.capacity().validate();
        }
        if (this.locationInfo() != null) {
            this.locationInfo().forEach(e -> e.validate());
        }
        if (this.costs() != null) {
            this.costs().forEach(e -> e.validate());
        }
        if (this.capabilities() != null) {
            this.capabilities().forEach(e -> e.validate());
        }
        if (this.restrictions() != null) {
            this.restrictions().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ApiManagementSkuInner fromJson(JsonReader jsonReader) throws IOException {
        return (ApiManagementSkuInner)jsonReader.readObject(reader -> {
            ApiManagementSkuInner deserializedApiManagementSkuInner = new ApiManagementSkuInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resourceType".equals(fieldName)) {
                    deserializedApiManagementSkuInner.resourceType = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedApiManagementSkuInner.name = reader.getString();
                    continue;
                }
                if ("tier".equals(fieldName)) {
                    deserializedApiManagementSkuInner.tier = reader.getString();
                    continue;
                }
                if ("size".equals(fieldName)) {
                    deserializedApiManagementSkuInner.size = reader.getString();
                    continue;
                }
                if ("family".equals(fieldName)) {
                    deserializedApiManagementSkuInner.family = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedApiManagementSkuInner.kind = reader.getString();
                    continue;
                }
                if ("capacity".equals(fieldName)) {
                    deserializedApiManagementSkuInner.capacity = ApiManagementSkuCapacity.fromJson(reader);
                    continue;
                }
                if ("locations".equals(fieldName)) {
                    List locations;
                    deserializedApiManagementSkuInner.locations = locations = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("locationInfo".equals(fieldName)) {
                    List locationInfo;
                    deserializedApiManagementSkuInner.locationInfo = locationInfo = reader.readArray(reader1 -> ApiManagementSkuLocationInfo.fromJson(reader1));
                    continue;
                }
                if ("apiVersions".equals(fieldName)) {
                    List apiVersions;
                    deserializedApiManagementSkuInner.apiVersions = apiVersions = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("costs".equals(fieldName)) {
                    List costs;
                    deserializedApiManagementSkuInner.costs = costs = reader.readArray(reader1 -> ApiManagementSkuCosts.fromJson(reader1));
                    continue;
                }
                if ("capabilities".equals(fieldName)) {
                    List capabilities;
                    deserializedApiManagementSkuInner.capabilities = capabilities = reader.readArray(reader1 -> ApiManagementSkuCapabilities.fromJson(reader1));
                    continue;
                }
                if ("restrictions".equals(fieldName)) {
                    List restrictions;
                    deserializedApiManagementSkuInner.restrictions = restrictions = reader.readArray(reader1 -> ApiManagementSkuRestrictions.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApiManagementSkuInner;
        });
    }
}

